package tv.twitch.chat;

public class ChatComment {
    public ChatMessageInfo messageInfo; //!< The common information about the message.
    public ChatComment
        [] replies; //!< Contains up to two replies to the original comment. Only applies for root comments.
    public String commentId; //!< The id of the chat comment.
    public String
        parentCommentId; //!< The id of the parent comment if this comment if a reply. Otherwise, empty string.
    public String contentId; //!< The ID of the VOD.
    public int channelId; //!< The channel ID of the VOD.
    public int
        timestampMilliseconds; //!< How far into the VOD the comment is in milliseconds. Only applies for root comments.
    public int updatedAt; //!< When the comment was last updated.
    public ChatCommentSource commentSource; //!< Whether the comment came from live chat or a VOD comment.
    public ChatCommentPublishedState
        publishedState; //!< The state of the message, whether it's published, pending review, etc.
    public boolean
        moreReplies; //!< True if there are more replies that are not stored in the replies vector. Only applies for root comments.
}
