package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/**
 * Whether a comment is published, pending review, or unpublished.
 */
public enum ChatCommentPublishedState {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Unknown(0), //!< Comment is in an unknown state.
    Published(1), //!< Comment is published.
    Unpublished(2), //!< Comment was manually unpublished by a mod or channel owner.
    PendingReview(3), //!< Comment was automatically flagged for review (AutoMod).
    PendingReviewSpam(4), //!< Comment is possibly spam and needs moderator review.
    Deleted(5); //!< Comment is deleted
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, ChatCommentPublishedState> s_Map = new HashMap<Integer, ChatCommentPublishedState>();

    static {
        EnumSet<ChatCommentPublishedState> set = EnumSet.allOf(ChatCommentPublishedState.class);

        for (ChatCommentPublishedState e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static ChatCommentPublishedState lookupValue(int val) {
        ChatCommentPublishedState err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private ChatCommentPublishedState(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
