package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/**
 * Where a chat comment originated from (live chat or VOD).
 */
public enum ChatCommentSource {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Unknown(0),
    Comment(1),
    Chat(2);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, ChatCommentSource> s_Map = new HashMap<Integer, ChatCommentSource>();

    static {
        EnumSet<ChatCommentSource> set = EnumSet.allOf(ChatCommentSource.class);

        for (ChatCommentSource e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static ChatCommentSource lookupValue(int val) {
        ChatCommentSource err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private ChatCommentSource(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
