package tv.twitch.chat;

import tv.twitch.ErrorCode;

public class ChatErrorCode extends ErrorCode {
    public static void forceClassInit() {}

    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    public static final ErrorCode TTV_EC_CHAT_BEGIN_ERRORS = new ChatErrorCode(0x10001, "TTV_EC_CHAT_BEGIN_ERRORS");
    public static final ErrorCode TTV_EC_CHAT_NO_HOSTS = new ChatErrorCode(0x10002, "TTV_EC_CHAT_NO_HOSTS");
    public static final ErrorCode TTV_EC_CHAT_ALREADY_IN_CHANNEL =
        new ChatErrorCode(0x10003, "TTV_EC_CHAT_ALREADY_IN_CHANNEL");
    public static final ErrorCode TTV_EC_CHAT_LOST_CONNECTION =
        new ChatErrorCode(0x10004, "TTV_EC_CHAT_LOST_CONNECTION");
    public static final ErrorCode TTV_EC_CHAT_COULD_NOT_CONNECT =
        new ChatErrorCode(0x10005, "TTV_EC_CHAT_COULD_NOT_CONNECT");
    public static final ErrorCode TTV_EC_CHAT_NOT_IN_CHANNEL = new ChatErrorCode(0x10006, "TTV_EC_CHAT_NOT_IN_CHANNEL");
    public static final ErrorCode TTV_EC_CHAT_INVALID_MESSAGE =
        new ChatErrorCode(0x10007, "TTV_EC_CHAT_INVALID_MESSAGE");
    public static final ErrorCode TTV_EC_CHAT_TOO_MANY_REQUESTS =
        new ChatErrorCode(0x10008, "TTV_EC_CHAT_TOO_MANY_REQUESTS");
    public static final ErrorCode TTV_EC_CHAT_LEAVING_CHANNEL =
        new ChatErrorCode(0x10009, "TTV_EC_CHAT_LEAVING_CHANNEL");
    public static final ErrorCode TTV_EC_CHAT_ANON_DENIED = new ChatErrorCode(0x1000a, "TTV_EC_CHAT_ANON_DENIED");
    public static final ErrorCode TTV_EC_CHAT_RESTRICTED = new ChatErrorCode(0x1000b, "TTV_EC_CHAT_RESTRICTED");
    public static final ErrorCode TTV_EC_CHAT_MESSAGE_SPAM_DISCARDED =
        new ChatErrorCode(0x1000c, "TTV_EC_CHAT_MESSAGE_SPAM_DISCARDED");
    public static final ErrorCode TTV_EC_CHAT_EMOTICON_DATA_NOT_READY =
        new ChatErrorCode(0x1000d, "TTV_EC_CHAT_EMOTICON_DATA_NOT_READY");
    public static final ErrorCode TTV_EC_CHAT_EMOTICON_DATA_DOWNLOADING =
        new ChatErrorCode(0x1000e, "TTV_EC_CHAT_EMOTICON_DATA_DOWNLOADING");
    public static final ErrorCode TTV_EC_CHAT_EMOTICON_DATA_LOCKED =
        new ChatErrorCode(0x1000f, "TTV_EC_CHAT_EMOTICON_DATA_LOCKED");
    public static final ErrorCode TTV_EC_CHAT_EMOTICON_DOWNLOAD_FAILED =
        new ChatErrorCode(0x10010, "TTV_EC_CHAT_EMOTICON_DOWNLOAD_FAILED");
    public static final ErrorCode TTV_EC_CHAT_INVALID_CHAT_THREAD_ID =
        new ChatErrorCode(0x10011, "TTV_EC_CHAT_INVALID_CHAT_THREAD_ID");
    public static final ErrorCode TTV_EC_CHAT_INVALID_CHAT_MESSAGE_ID =
        new ChatErrorCode(0x10012, "TTV_EC_CHAT_INVALID_CHAT_MESSAGE_ID");
    public static final ErrorCode TTV_EC_CHAT_END_ERRORS = new ChatErrorCode(0x10013, "TTV_EC_CHAT_END_ERRORS");
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private ChatErrorCode(int value, String name) { super(value, name); }
}
