package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ChatGraphQLErrorCode {
    SUCCESS(0),
    UNKNOWN(1),
    AUTO_MOD_ENFORCEMENT_FAILED(2),
    CHANNEL_NOT_FOUND(3),
    DURATION_INVALID(4),
    EMOTE_ONLY_MODE_ENFORCEMENT_FAILED(5),
    FORBIDDEN(6),
    MAX_ROOMS_LIMIT_EXCEEDED(7),
    NAME_CONTAINS_INVALID_CHARACTERS(8),
    NAME_INAPPROPRIATE(9),
    NAME_LENGTH_INVALID(10),
    R9K_MODE_ENFORCEMENT_FAILED(11),
    RATE_LIMIT_FAILED(12),
    ROLES_INVALID(13),
    ROOM_NOT_FOUND(14),
    SLOW_MODE_DURATION_INVALID(15),
    SLOW_MODE_ENFORCEMENT_FAILED(16),
    SPAM_ENFORCEMENT_FAILED(17),
    TARGET_ALREADY_BANNED(18),
    TARGET_ALREADY_MOD(19),
    TARGET_IS_ADMIN(20),
    TARGET_IS_ANONYMOUS(21),
    TARGET_IS_BROADCASTER(22),
    TARGET_IS_CHAT_BANNED(23),
    TARGET_IS_GLOBAL_MOD(24),
    TARGET_IS_MOD(25),
    TARGET_IS_SELF(26),
    TARGET_IS_STAFF(27),
    TARGET_NOT_BANNED(28),
    TARGET_NOT_FOUND(29),
    TARGET_NOT_MOD(30),
    TOPIC_INAPPROPRIATE(31),
    TOPIC_LENGTH_INVALID(32),
    USER_CHAT_BANNED(33),
    USER_CHAT_TIMED_OUT(34),
    USER_SUSPENDED(35),
    ZALGO_ENFORCEMENT_FAILED(36);

    private static Map<Integer, ChatGraphQLErrorCode> s_Map = new HashMap<Integer, ChatGraphQLErrorCode>();

    static {
        EnumSet<ChatGraphQLErrorCode> set = EnumSet.allOf(ChatGraphQLErrorCode.class);

        for (ChatGraphQLErrorCode e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static ChatGraphQLErrorCode lookupValue(int val) {
        ChatGraphQLErrorCode err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private ChatGraphQLErrorCode(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
