package tv.twitch.chat;

import java.util.HashMap;

public class ChatLiveMessage {
    public ChatMessageInfo messageInfo;
    public String messageId;

    public static ChatLiveMessage[] deserializeColferMessage(byte[] serializedMessage) {
        tv.twitch.chat.colfer.ChatMessageArray messageArray = new tv.twitch.chat.colfer.ChatMessageArray();
        messageArray.unmarshal(serializedMessage, 0);

        tv.twitch.chat.colfer.ChatMessage[] colferMessages = messageArray.getMessages();
        ChatLiveMessage[] messageList = new ChatLiveMessage[colferMessages.length];

        for (int k = 0; k < colferMessages.length; k++) {
            tv.twitch.chat.colfer.ChatMessage colferMessage = colferMessages[k];

            messageList[k] = new ChatLiveMessage();
            messageList[k].messageId = colferMessage.message_id;

            messageList[k].messageInfo = new ChatMessageInfo();
            messageList[k].messageInfo.userName = colferMessage.user_name;
            messageList[k].messageInfo.displayName = colferMessage.display_name;
            messageList[k].messageInfo.userId = colferMessage.user_id;
            messageList[k].messageInfo.messageType = colferMessage.message_type;

            messageList[k].messageInfo.userMode = new ChatUserMode();
            messageList[k].messageInfo.userMode.moderator = colferMessage.usermode_moderator;
            messageList[k].messageInfo.userMode.broadcaster = colferMessage.usermode_broadcaster;
            messageList[k].messageInfo.userMode.administrator = colferMessage.usermode_administrator;
            messageList[k].messageInfo.userMode.staff = colferMessage.usermode_staff;
            messageList[k].messageInfo.userMode.system = colferMessage.usermode_system;
            messageList[k].messageInfo.userMode.globalModerator = colferMessage.usermode_global_moderator;
            messageList[k].messageInfo.userMode.banned = colferMessage.usermode_banned;
            messageList[k].messageInfo.userMode.subscriber = colferMessage.usermode_subscriber;
            messageList[k].messageInfo.userMode.vip = colferMessage.usermode_vip;

            messageList[k].messageInfo.nameColorARGB = colferMessage.name_color_argb;
            messageList[k].messageInfo.flags.action = colferMessage.messageflags_action;
            messageList[k].messageInfo.flags.notice = colferMessage.messageflags_notice;
            messageList[k].messageInfo.flags.ignored = colferMessage.messageflags_ignored;
            messageList[k].messageInfo.flags.deleted = colferMessage.messageflags_deleted;
            messageList[k].messageInfo.flags.containsBits = colferMessage.messageflags_contains_bits;

            messageList[k].messageInfo.timestamp = colferMessage.timestamp;
            messageList[k].messageInfo.numBitsSent = colferMessage.num_bits_sent;

            tv.twitch.chat.colfer.MessageToken[] tokens = colferMessage.getTokens();
            messageList[k].messageInfo.tokens = new ChatMessageToken[tokens.length];
            for (int j = 0; j < tokens.length; j++) {
                tv.twitch.chat.colfer.MessageToken colferToken = tokens[j];
                switch (colferToken.token_type) {
                    case 0:
                        // TextToken
                        ChatTextToken textToken = new ChatTextToken();
                        textToken.text = colferToken.text_field_1;
                        textToken.autoModFlags.aggressiveLevel = colferToken.aggressive_level;
                        textToken.autoModFlags.identityLevel = colferToken.identity_level;
                        textToken.autoModFlags.profanityLevel = colferToken.profanity_level;
                        textToken.autoModFlags.sexualLevel = colferToken.sexual_level;
                        messageList[k].messageInfo.tokens[j] = textToken;
                        break;
                    case 1:
                        // EmoticonToken
                        ChatEmoticonToken emoticonToken = new ChatEmoticonToken();
                        emoticonToken.emoticonId = colferToken.text_field_2;
                        emoticonToken.emoticonText = colferToken.text_field_1;
                        messageList[k].messageInfo.tokens[j] = emoticonToken;
                        break;
                    case 2:
                        // MentionToken
                        ChatMentionToken mentionToken = new ChatMentionToken();
                        mentionToken.userName = colferToken.text_field_1;
                        mentionToken.text = colferToken.text_field_2;
                        mentionToken.isLocalUser = colferToken.bool_field;
                        messageList[k].messageInfo.tokens[j] = mentionToken;
                        break;
                    case 3:
                        // UrlToken
                        ChatUrlToken urlToken = new ChatUrlToken();
                        urlToken.url = colferToken.text_field_1;
                        urlToken.hidden = colferToken.bool_field;
                        messageList[k].messageInfo.tokens[j] = urlToken;
                        break;
                    case 4:
                        // BitsToken
                        ChatBitsToken bitsToken = new ChatBitsToken();
                        bitsToken.prefix = colferToken.text_field_1;
                        bitsToken.numBits = colferToken.num_field;
                        messageList[k].messageInfo.tokens[j] = bitsToken;
                        break;
                }
            }

            tv.twitch.chat.colfer.MessageBadge[] badges = colferMessage.getBadges();
            messageList[k].messageInfo.badges = new ChatMessageBadge[badges.length];
            for (int j = 0; j < badges.length; j++) {
                ChatMessageBadge badge = new ChatMessageBadge();
                badge.name = badges[j].name;
                badge.version = badges[j].version;
                messageList[k].messageInfo.badges[j] = badge;
            }

            tv.twitch.chat.colfer.MessageTag[] messageTags = colferMessage.getMessage_tags();
            messageList[k].messageInfo.messageTags = new HashMap<String, String>();
            for (int j = 0; j < messageTags.length; j++) {
                messageList[k].messageInfo.messageTags.put(messageTags[j].key, messageTags[j].value);
            }
        }

        return messageList;
    }
}
