package tv.twitch.chat;

import tv.twitch.*;

public class ChatMessageHandler extends NativeProxy {
    public interface ICallbacks {
        boolean passThrough(String message);
        boolean blockUser(String blockUserName);
        boolean unblockUser(String unblockUserName);
        boolean whisperUser(String whisperUserName, String message);
        boolean createRaid(String raidTargetUserName);
        boolean cancelRaid();
        boolean grantVIP(String vipUserName);
        boolean revokeVIP(String unvipUserName);
        boolean listVIPs();
    }

    /**
     * Legacy constructor.
     * @Deprecated Use {@link ChatMessageHandler(IJniThreadChecker)}
     */
    @Deprecated
    public ChatMessageHandler() {
        super(PassThroughJniThreadValidator.INSTANCE);
    }

    public ChatMessageHandler(IJniThreadChecker jniThreadChecker) { super(new JniThreadValidator(jniThreadChecker)); }

    private native long CreateNativeInstance();
    // AND-9927 Disposing a ChatMessageHandler is safe on any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);
    private native boolean HandleMessage(long nativeObjectPointer, String message);
    private native void SetCallbacks(long nativeObjectPointer, ICallbacks callbacks);

    @Override
    protected long createNativeInstance() {
        return mJniThreadValidator.callJniCallable(new IJniCallable<Long>() {
            @Override
            public Long call() {
                return CreateNativeInstance();
            }
        });
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing a ChatMessageHandler is safe on any thread
        DisposeNativeInstance(nativeObjectPointer);
    }

    public boolean handleMessage(final String message) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<Boolean>() {
            @Override
            public Boolean call() {
                return HandleMessage(getNativeObjectPointer(), message);
            }
        });
    }

    public void setCallbacks(final ICallbacks callbacks) {
        mJniThreadValidator.callJniRunnable(new Runnable() {
            @Override
            public void run() {
                SetCallbacks(getNativeObjectPointer(), callbacks);
            }
        });
    }
}
