package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/**
 * The types of tokens that can be generated from a chat message.
 */
public enum ChatMessageTokenType {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Text(0),
    Emoticon(1),
    Mention(2),
    Url(3),
    Bits(4);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, ChatMessageTokenType> s_Map = new HashMap<Integer, ChatMessageTokenType>();

    static {
        EnumSet<ChatMessageTokenType> set = EnumSet.allOf(ChatMessageTokenType.class);

        for (ChatMessageTokenType e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static ChatMessageTokenType lookupValue(int val) {
        ChatMessageTokenType err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private ChatMessageTokenType(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
