package tv.twitch.chat;

import tv.twitch.*;

public class ChatRaidProxy extends NativeProxy implements IChatRaid {
    // AND-9927 Disposing a ChatRaidProxy is safe on any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    private native ErrorCode Join(long nativeObjectPointer, String raidId, JoinCallback callback);
    private native ErrorCode Leave(long nativeObjectPointer, String raidId, LeaveCallback callback);
    private native ErrorCode Start(long nativeObjectPointer, int targetUserId, StartCallback callback);
    private native ErrorCode RaidNow(long nativeObjectPointer, RaidNowCallback callback);
    private native ErrorCode Cancel(long nativeObjectPointer, CancelCallback callback);

    public ChatRaidProxy(long nativeObjectPointer, IJniThreadValidator jniThreadValidator) {
        super(nativeObjectPointer, jniThreadValidator);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing a ChatRaidProxy is safe on any thread
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public ErrorCode join(final String raidId, final JoinCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Join(getNativeObjectPointer(), raidId, callback);
            }
        });
    }

    @Override
    public ErrorCode leave(final String raidId, final LeaveCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Leave(getNativeObjectPointer(), raidId, callback);
            }
        });
    }

    @Override
    public ErrorCode start(final int targetUserId, final StartCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Start(getNativeObjectPointer(), targetUserId, callback);
            }
        });
    }

    @Override
    public ErrorCode raidNow(final RaidNowCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return RaidNow(getNativeObjectPointer(), callback);
            }
        });
    }

    @Override
    public ErrorCode cancel(final CancelCallback callback) {
        return mJniThreadValidator.callJniCallable(new IJniCallable<ErrorCode>() {
            @Override
            public ErrorCode call() {
                return Cancel(getNativeObjectPointer(), callback);
            }
        });
    }
}
