package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

import tv.twitch.*;

// AND-9927 SDK-755 Not audited for thread safety because this should be deleted
public class ChatRoomMessageHandler extends NativeProxy {
    public enum CommandError {
        // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
        Unknown(0),
        Ban(1),
        Unban(2),
        Timeout(3),
        Untimeout(4),
        Mod(5),
        Unmod(6),
        Ignore(7),
        Unignore(8),
        Color(9),
        Topic(10),
        Slow(11),
        Me(12);
        // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

        private static Map<Integer, CommandError> s_Map = new HashMap<Integer, CommandError>();

        static {
            EnumSet<CommandError> set = EnumSet.allOf(CommandError.class);

            for (CommandError e : set) {
                s_Map.put(e.getValue(), e);
            }
        }

        public static CommandError lookupValue(int val) {
            CommandError err = s_Map.get(val);
            return err;
        }

        private int m_Value;

        private CommandError(int value) { this.m_Value = value; }

        public int getValue() { return m_Value; }
    }

    public interface ICallbacks {
        boolean passThrough(String message);
        boolean banUser(String userName);
        boolean timeoutUser(String userName, int duration);
        boolean setUserColor(String color);
        boolean help();
        boolean listRooms();
        boolean modUser(String userName);
        boolean listModerators();
        boolean setTopic(String topic);
        boolean unbanUser(String userName);
        boolean unmodUser(String userName);
        boolean untimeoutUser(String userName);
        boolean blockUser(String userName);
        boolean unblockUser(String userName);
        boolean slowMode(boolean turnOn, int duration);
        boolean r9kMode(boolean turnOn);
        boolean emotesOnlyMode(boolean turnOn);
        boolean malformedCommand(CommandError command, String commandText);
    }

    public ChatRoomMessageHandler() {
        // AND-9927 SDK-755 Not audited for thread safety because this should be deleted
        super(PassThroughJniThreadValidator.INSTANCE);
    }

    // AND-9927 SDK-755 Not audited for thread safety because this should be deleted
    private native long CreateNativeInstance();
    private native void DisposeNativeInstance(long nativeObjectPointer);
    private native boolean HandleMessage(long nativeObjectPointer, String message);
    private native void SetCallbacks(long nativeObjectPointer, ICallbacks callbacks);

    @Override
    protected long createNativeInstance() {
        return CreateNativeInstance();
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        DisposeNativeInstance(nativeObjectPointer);
    }

    public boolean handleMessage(String message) { return HandleMessage(getNativeObjectPointer(), message); }

    public void setCallbacks(ICallbacks callbacks) { SetCallbacks(getNativeObjectPointer(), callbacks); }
}
