package tv.twitch.chat;

import tv.twitch.CoreErrorCode;
import tv.twitch.ErrorCode;
import tv.twitch.NativeProxy;
import tv.twitch.PassThroughJniThreadValidator;
import tv.twitch.ResultContainer;

// AND-9927 SDK-755 Not audited for thread safety because this should be deleted
public class ChatRoomProxy extends NativeProxy implements IChatRoom {
    // AND-9927 SDK-755 Not audited for thread safety because this should be deleted
    private native ErrorCode DeleteRoom(long nativeObjectPointer, DeleteRoomCallback callback);
    private native ErrorCode SendMessage(long nativeObjectPointer, String message,
        ResultContainer<ChatRoomMessage> placeholderMessage, SendMessageCallback callback);
    private native ErrorCode EditMessage(long nativeObjectPointer, String messageId, String message,
        ResultContainer<ChatRoomMessage> placeholderMessage, EditMessageCallback callback);
    private native ErrorCode DeleteMessage(long nativeObjectPointer, String messageId, DeleteMessageCallback callback);
    private native ErrorCode FetchMessagesBeforeCursor(
        long nativeObjectPointer, String cursor, int limit, FetchMessagesCallback callback);
    private native ErrorCode FetchMessagesAfterCursor(
        long nativeObjectPointer, String cursor, int limit, FetchMessagesCallback callback);
    private native ErrorCode FetchMessagesBeforeTimestamp(
        long nativeObjectPointer, int timestamp, int limit, FetchMessagesCallback callback);
    private native ErrorCode FetchMessagesAfterTimestamp(
        long nativeObjectPointer, int timestamp, int limit, FetchMessagesCallback callback);
    private native ErrorCode SetRoomName(long nativeObjectPointer, String name, UpdateRoomInfoCallback callback);
    private native ErrorCode SetTopic(long nativeObjectPointer, String topic, UpdateRoomInfoCallback callback);
    private native ErrorCode SetRoomRolePermissions(
        long nativeObjectPointer, RoomRolePermissions permissions, UpdateRoomInfoCallback callback);
    private native ErrorCode EnableSlowMode(
        long nativeObjectPointer, int durationSeconds, UpdateRoomModesCallback callback);
    private native ErrorCode DisableSlowMode(long nativeObjectPointer, UpdateRoomModesCallback callback);
    private native ErrorCode EnableR9kMode(long nativeObjectPointer, UpdateRoomModesCallback callback);
    private native ErrorCode DisableR9kMode(long nativeObjectPointer, UpdateRoomModesCallback callback);
    private native ErrorCode EnableEmotesOnlyMode(long nativeObjectPointer, UpdateRoomModesCallback callback);
    private native ErrorCode DisableEmotesOnlyMode(long nativeObjectPointer, UpdateRoomModesCallback callback);
    private native ErrorCode SetLastReadAt(long nativeObjectPointer, int lastReadAt, UpdateRoomViewCallback callback);
    private native ErrorCode SetMuted(long nativeObjectPointer, boolean isMuted, UpdateRoomViewCallback callback);
    private native ErrorCode SetArchived(long nativeObjectPointer, boolean isArchived, UpdateRoomViewCallback callback);
    private native ErrorCode FetchRoomInfo(long nativeObjectPointer, FetchRoomInfoCallback callback);
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public ChatRoomProxy(long nativeObjectPointer) {
        // AND-9927 SDK-755 Not audited for thread safety because this should be deleted
        super(nativeObjectPointer, PassThroughJniThreadValidator.INSTANCE);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public ErrorCode deleteRoom(DeleteRoomCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return DeleteRoom(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode sendMessage(
        String message, ResultContainer<ChatRoomMessage> placeholderMessage, SendMessageCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return SendMessage(ptr, message, placeholderMessage, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode editMessage(String messageId, String message, ResultContainer<ChatRoomMessage> placeholderMessage,
        EditMessageCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return EditMessage(ptr, messageId, message, placeholderMessage, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode deleteMessage(String messageId, DeleteMessageCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return DeleteMessage(ptr, messageId, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode fetchMessagesBeforeCursor(String cursor, int limit, FetchMessagesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return FetchMessagesBeforeCursor(ptr, cursor, limit, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode fetchMessagesAfterCursor(String cursor, int limit, FetchMessagesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return FetchMessagesAfterCursor(ptr, cursor, limit, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode fetchMessagesBeforeTimestamp(int timestamp, int limit, FetchMessagesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return FetchMessagesBeforeTimestamp(ptr, timestamp, limit, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode fetchMessagesAfterTimestamp(int timestamp, int limit, FetchMessagesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return FetchMessagesAfterTimestamp(ptr, timestamp, limit, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode setRoomName(String name, UpdateRoomInfoCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return SetRoomName(ptr, name, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode setTopic(String topic, UpdateRoomInfoCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return SetTopic(ptr, topic, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode setRoomRolePermissions(RoomRolePermissions permissions, UpdateRoomInfoCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return SetRoomRolePermissions(ptr, permissions, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode enableSlowMode(int durationSeconds, UpdateRoomModesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return EnableSlowMode(ptr, durationSeconds, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode disableSlowMode(UpdateRoomModesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return DisableSlowMode(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode enableR9kMode(UpdateRoomModesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return EnableR9kMode(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode disableR9kMode(UpdateRoomModesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return DisableR9kMode(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode enableEmotesOnlyMode(UpdateRoomModesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return EnableEmotesOnlyMode(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode disableEmotesOnlyMode(UpdateRoomModesCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return DisableEmotesOnlyMode(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode setLastReadAt(int lastReadAt, UpdateRoomViewCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return SetLastReadAt(ptr, lastReadAt, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode setMuted(boolean isMuted, UpdateRoomViewCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return SetMuted(ptr, isMuted, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode setArchived(boolean isArchived, UpdateRoomViewCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return SetArchived(ptr, isArchived, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }

    @Override
    public ErrorCode fetchRoomInfo(FetchRoomInfoCallback callback) {
        long ptr = getNativeObjectPointer();

        if (ptr != 0) {
            return FetchRoomInfo(ptr, callback);
        } else {
            return CoreErrorCode.TTV_EC_INVALID_INSTANCE;
        }
    }
}
