package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ChatSubscriptionNoticeType {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Sub(0),
    Resub(1),
    SubGift(2),
    SubMassGift(3),
    Charity(4),
    ExtendSub(5),
    Unknown(6);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, ChatSubscriptionNoticeType> s_Map = new HashMap<Integer, ChatSubscriptionNoticeType>();

    static {
        EnumSet<ChatSubscriptionNoticeType> set = EnumSet.allOf(ChatSubscriptionNoticeType.class);

        for (ChatSubscriptionNoticeType e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static ChatSubscriptionNoticeType lookupValue(int val) {
        ChatSubscriptionNoticeType err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private ChatSubscriptionNoticeType(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
