package tv.twitch.chat;

/**
 * The user information.
 */
public class ChatUserInfo {
    public String userName = null;
    public String displayName = null;
    public ChatUserMode userMode = new ChatUserMode();
    public int nameColorARGB = 0;
    public int userId = 0;

    public ChatUserInfo copy() {
        ChatUserInfo copy = new ChatUserInfo();
        copy.userName = userName;
        copy.displayName = displayName;
        copy.userMode = userMode;
        copy.nameColorARGB = nameColorARGB;
        return copy;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();

        sb.append(userName).append(" [");

        boolean anyUserMode = false;
        if (userMode.administrator) {
            sb.append("Admin");
            anyUserMode = true;
        }
        if (userMode.broadcaster) {
            sb.append("Broad");
            anyUserMode = true;
        }
        if (userMode.banned) {
            sb.append("Ban");
            anyUserMode = true;
        }
        if (userMode.moderator) {
            sb.append("Mod");
            anyUserMode = true;
        }
        if (userMode.globalModerator) {
            sb.append("Gblmod");
            anyUserMode = true;
        }
        if (userMode.staff) {
            sb.append("Staff");
            anyUserMode = true;
        }
        if (userMode.subscriber) {
            sb.append("Sub");
            anyUserMode = true;
        }
        if (!anyUserMode) {
            sb.append("Viewer");
        }

        sb.append("]");

        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        } else if (!(other instanceof ChatUserInfo)) {
            return false;
        } else {
            ChatUserInfo user = (ChatUserInfo) other;
            return this.userName.equals(user.userName);
        }
    }
}
