package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum CommentPublishingMode {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Unknown(0),
    Open(1),
    Review(2),
    Disabled(3);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, CommentPublishingMode> s_Map = new HashMap<Integer, CommentPublishingMode>();

    static {
        EnumSet<CommentPublishingMode> set = EnumSet.allOf(CommentPublishingMode.class);

        for (CommentPublishingMode e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static CommentPublishingMode lookupValue(int val) {
        CommentPublishingMode err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private CommentPublishingMode(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
