package tv.twitch.chat;

import tv.twitch.NativeProxy;
import tv.twitch.PassThroughJniThreadValidator;

public class FollowingStatusProxy extends NativeProxy implements IFollowingStatus {
    // AND-9927 Disposing a FollowingStatusProxy is safe from any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public FollowingStatusProxy(long nativeObjectPointer) {
        super(nativeObjectPointer, PassThroughJniThreadValidator.INSTANCE);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing a FollowingStatusProxy is safe from any thread
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}
