package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum GrantVIPErrorCode {
    SUCCESS(0),
    UNKNOWN(1),
    CHANNEL_NOT_FOUND(2),
    FORBIDDEN(3),
    GRANTEE_ALREADY_VIP(4),
    GRANTEE_CHAT_BANNED(5),
    GRANTEE_NOT_FOUND(6),
    MAX_VIPS_REACHED(7),
    VIP_ACHIEVEMENT_INCOMPLETE(8);

    private static Map<Integer, GrantVIPErrorCode> s_Map = new HashMap<Integer, GrantVIPErrorCode>();

    static {
        EnumSet<GrantVIPErrorCode> set = EnumSet.allOf(GrantVIPErrorCode.class);

        for (GrantVIPErrorCode e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static GrantVIPErrorCode lookupValue(int val) {
        GrantVIPErrorCode err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private GrantVIPErrorCode(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
