package tv.twitch.chat;

import tv.twitch.ErrorCode;

public interface IChannelChatRoomManager {
    public interface JoinCallback { void invoke(ErrorCode ec); }
    public interface LeaveCallback { void invoke(ErrorCode ec); }
    public interface AddRoomCallback { void invoke(ErrorCode ec, CreateRoomError error, ChatRoomInfo info); }
    public interface FetchRoomsInfoCallback { void invoke(ErrorCode ec, ChatRoomInfo[] infos); }

    void dispose();
    ErrorCode addNewChatRoom(String roomName, String topic, RoomRolePermissions permissions, AddRoomCallback callback);
    ErrorCode joinChatRooms(JoinCallback callback);
    ErrorCode leaveChatRooms(LeaveCallback callback);
    ErrorCode fetchChatRoomsInfo(FetchRoomsInfoCallback callback);
}
