package tv.twitch.chat;

import tv.twitch.ErrorCode;
import tv.twitch.Result;

public interface IChatCommentManager {
    public interface FetchCommentsCallback { void invoke(ErrorCode ec, ChatComment[] result, String nextCursor); }
    public interface FetchCommentCallback { void invoke(ErrorCode ec, ChatComment result); }
    public interface DeleteCommentCallback { void invoke(ErrorCode ec); }
    public interface PostCommentCallback { void invoke(ErrorCode ec, ChatComment result, String errorMessage); }
    public interface ReportCommentCallback { void invoke(ErrorCode ec); }
    public interface FetchCommentRepliesCallback { void invoke(ErrorCode ec, ChatComment[] result); }
    public interface PostCommentReplyCallback { void invoke(ErrorCode ec, ChatComment result); }

    void dispose();
    ErrorCode play();
    ErrorCode pause();
    ErrorCode updatePlayhead(int timestampMilliseconds);
    Result<Integer> getPlayheadTime();
    Result<Integer> getChannelId();
    Result<PlayingState> getPlayingState();
    ErrorCode fetchCommentsByTimestamp(int timestampMilliseconds, int limit, FetchCommentsCallback callback);
    ErrorCode fetchCommentsByCursor(String cursor, int limit, FetchCommentsCallback callback);
    ErrorCode fetchComment(String commentId, FetchCommentCallback callback);
    ErrorCode deleteComment(String commentId, DeleteCommentCallback callback);
    ErrorCode postComment(String message, int timestampMilliseconds, PostCommentCallback callback);
    ErrorCode reportComment(String commentId, String reason, String description, ReportCommentCallback callback);
    ErrorCode fetchCommentReplies(String commentId, FetchCommentRepliesCallback callback);
    ErrorCode postCommentReply(String parentCommentId, String message, PostCommentReplyCallback callback);
}
