package tv.twitch.chat;

import tv.twitch.ErrorCode;

public interface IChatRaid {
    public interface JoinCallback { void invoke(ErrorCode ec); }
    public interface LeaveCallback { void invoke(ErrorCode ec); }
    public interface StartCallback { void invoke(ErrorCode ec); }
    public interface RaidNowCallback { void invoke(ErrorCode ec); }
    public interface CancelCallback { void invoke(ErrorCode ec); }

    ErrorCode join(String raidId, JoinCallback callback);
    ErrorCode leave(String raidId, LeaveCallback callback);
    ErrorCode start(int targetUserId, StartCallback callback);
    ErrorCode raidNow(RaidNowCallback callback);
    ErrorCode cancel(CancelCallback callback);
}
