package tv.twitch.chat;

import tv.twitch.ErrorCode;
import tv.twitch.ResultContainer;

public interface IChatRoom {
    public interface DeleteRoomCallback { void invoke(ErrorCode ec); }
    public interface SendMessageCallback {
        void invoke(ErrorCode ec, SendRoomMessageError error, ChatRoomMessage message);
    }
    public interface EditMessageCallback { void invoke(ErrorCode ec, ChatRoomMessage message); }
    public interface DeleteMessageCallback { void invoke(ErrorCode ec); }
    public interface FetchMessagesCallback {
        void invoke(ErrorCode ec, ChatRoomMessage[] messages, String nextCursor, boolean moreMessages);
    }
    public interface UpdateRoomInfoCallback { void invoke(ErrorCode ec, UpdateRoomError error, ChatRoomInfo info); }
    public interface UpdateRoomModesCallback {
        void invoke(ErrorCode ec, UpdateRoomModesError error, ChatRoomInfo info);
    }
    public interface UpdateRoomViewCallback { void invoke(ErrorCode ec, ChatRoomInfo info); }
    public interface FetchRoomInfoCallback { void invoke(ErrorCode ec, ChatRoomInfo info); }

    void dispose();
    ErrorCode deleteRoom(DeleteRoomCallback callback);
    ErrorCode sendMessage(
        String message, ResultContainer<ChatRoomMessage> placeholderMessage, SendMessageCallback callback);
    ErrorCode editMessage(String messageId, String message, ResultContainer<ChatRoomMessage> placeholderMessage,
        EditMessageCallback callback);
    ErrorCode deleteMessage(String messageId, DeleteMessageCallback callback);
    ErrorCode fetchMessagesBeforeCursor(String cursor, int limit, FetchMessagesCallback callback);
    ErrorCode fetchMessagesAfterCursor(String cursor, int limit, FetchMessagesCallback callback);
    ErrorCode fetchMessagesBeforeTimestamp(int timestamp, int limit, FetchMessagesCallback callback);
    ErrorCode fetchMessagesAfterTimestamp(int timestamp, int limit, FetchMessagesCallback callback);
    ErrorCode setRoomName(String name, UpdateRoomInfoCallback callback);
    ErrorCode setTopic(String topic, UpdateRoomInfoCallback callback);
    ErrorCode setRoomRolePermissions(RoomRolePermissions permissions, UpdateRoomInfoCallback callback);
    ErrorCode enableSlowMode(int durationSeconds, UpdateRoomModesCallback callback);
    ErrorCode disableSlowMode(UpdateRoomModesCallback callback);
    ErrorCode enableR9kMode(UpdateRoomModesCallback callback);
    ErrorCode disableR9kMode(UpdateRoomModesCallback callback);
    ErrorCode enableEmotesOnlyMode(UpdateRoomModesCallback callback);
    ErrorCode disableEmotesOnlyMode(UpdateRoomModesCallback callback);
    ErrorCode setLastReadAt(int lastReadAt, UpdateRoomViewCallback callback);
    ErrorCode setMuted(boolean isMuted, UpdateRoomViewCallback callback);
    ErrorCode setArchived(boolean isArchived, UpdateRoomViewCallback callback);
    ErrorCode fetchRoomInfo(FetchRoomInfoCallback callback);
}
