package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/**
 * Whether a comment is published, pending review, or unpublished.
 */
public enum PlayingState {
    // BINDING_ENUM_START (Do not remove this line, it's used by the bindings tools)
    Paused(0),
    Playing(1),
    Buffering(2),
    Finished(3);
    // BINDING_ENUM_END (Do not remove this line, it's used by the bindings tools)

    private static Map<Integer, PlayingState> s_Map = new HashMap<Integer, PlayingState>();

    static {
        EnumSet<PlayingState> set = EnumSet.allOf(PlayingState.class);

        for (PlayingState e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static PlayingState lookupValue(int val) {
        PlayingState err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private PlayingState(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
