package tv.twitch.chat;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum RevokeVIPErrorCode {
    SUCCESS(0),
    UNKNOWN(1),
    CHANNEL_NOT_FOUND(2),
    FORBIDDEN(3),
    REVOKEE_NOT_FOUND(4),
    REVOKEE_NOT_VIP(5);

    private static Map<Integer, RevokeVIPErrorCode> s_Map = new HashMap<Integer, RevokeVIPErrorCode>();

    static {
        EnumSet<RevokeVIPErrorCode> set = EnumSet.allOf(RevokeVIPErrorCode.class);

        for (RevokeVIPErrorCode e : set) {
            s_Map.put(e.getValue(), e);
        }
    }

    public static RevokeVIPErrorCode lookupValue(int val) {
        RevokeVIPErrorCode err = s_Map.get(val);
        return err;
    }

    private int m_Value;

    private RevokeVIPErrorCode(int value) { this.m_Value = value; }

    public int getValue() { return m_Value; }
}
