package tv.twitch.chat;

import tv.twitch.NativeProxy;
import tv.twitch.PassThroughJniThreadValidator;

public class SquadNotificationsProxy extends NativeProxy implements ISquadNotifications {
    // AND-9927 Disposing a SquadNotificationsProxy is safe from any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public SquadNotificationsProxy(long nativeObjectPointer) {
        // AND-9927 Disposing a SquadNotificationsProxy is safe from any thread
        super(nativeObjectPointer, PassThroughJniThreadValidator.INSTANCE);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing a SquadNotificationsProxy is safe from any thread
        DisposeNativeInstance(nativeObjectPointer);
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}
