package tv.twitch.chat;

import tv.twitch.*;

public class SubscribersStatusProxy extends NativeProxy implements ISubscribersStatus {
    // AND-9927 Disposing a SubscribersStatusProxy is safe from any thread
    private native void DisposeNativeInstance(long nativeObjectPointer);

    public SubscribersStatusProxy(long nativeObjectPointer) {
        // AND-9927 Disposing a SubscribersStatusProxy is safe from any thread
        super(nativeObjectPointer, PassThroughJniThreadValidator.INSTANCE);
    }

    @Override
    protected void disposeNativeInstance(long nativeObjectPointer) {
        // AND-9927 Disposing a SubscribersStatusProxy is safe from any thread
        DisposeNativeInstance(nativeObjectPointer);
    }
}
