package tv.twitch.chat.colfer;

// Code generated by colf(1); DO NOT EDIT.

import static java.lang.String.format;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.InputMismatchException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * Data bean with built-in serialization support.

 * @author generated by colf(1)
 * @see <a href="https://github.com/pascaldekloe/colfer">Colfer's home</a>
 */
public class ChatMessage implements Serializable {
    /** The upper limit for serial byte sizes. */
    public static int colferSizeMax = 16 * 1024 * 1024;

    /** The upper limit for the number of elements in a list. */
    public static int colferListMax = 64 * 1024;

    public String message_id;

    public String user_name;

    public String display_name;

    public String message_type;

    public int user_id;

    public int name_color_argb;

    public int timestamp;

    public int num_bits_sent;

    public boolean usermode_moderator;

    public boolean usermode_broadcaster;

    public boolean usermode_administrator;

    public boolean usermode_staff;

    public boolean usermode_system;

    public boolean usermode_global_moderator;

    public boolean usermode_banned;

    public boolean usermode_subscriber;

    public boolean usermode_vip;

    public boolean messageflags_action;

    public boolean messageflags_notice;

    public boolean messageflags_ignored;

    public boolean messageflags_deleted;

    public boolean messageflags_contains_bits;

    public MessageToken[] tokens;

    public MessageBadge[] badges;

    public MessageTag[] message_tags;

    /** Default constructor */
    public ChatMessage() { init(); }

    private static final MessageToken[] _zeroTokens = new MessageToken[0];
    private static final MessageBadge[] _zeroBadges = new MessageBadge[0];
    private static final MessageTag[] _zeroMessage_tags = new MessageTag[0];

    /** Colfer zero values. */
    private void init() {
        message_id = "";
        user_name = "";
        display_name = "";
        message_type = "";
        tokens = _zeroTokens;
        badges = _zeroBadges;
        message_tags = _zeroMessage_tags;
    }

    /**
     * {@link #reset(InputStream) Reusable} deserialization of Colfer streams.
     */
    public static class Unmarshaller {
        /** The data source. */
        protected InputStream in;

        /** The read buffer. */
        public byte[] buf;

        /** The {@link #buf buffer}'s data start index, inclusive. */
        protected int offset;

        /** The {@link #buf buffer}'s data end index, exclusive. */
        protected int i;

        /**
         * @param in the data source or {@code null}.
         * @param buf the initial buffer or {@code null}.
         */
        public Unmarshaller(InputStream in, byte[] buf) {
            // TODO: better size estimation
            if (buf == null || buf.length == 0)
                buf = new byte[Math.min(ChatMessage.colferSizeMax, 2048)];
            this.buf = buf;
            reset(in);
        }

        /**
         * Reuses the marshaller.
         * @param in the data source or {@code null}.
         * @throws IllegalStateException on pending data.
         */
        public void reset(InputStream in) {
            if (this.i != this.offset)
                throw new IllegalStateException("colfer: pending data");
            this.in = in;
            this.offset = 0;
            this.i = 0;
        }

        /**
         * Deserializes the following object.
         * @return the result or {@code null} when EOF.
         * @throws IOException from the input stream.
         * @throws SecurityException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
         *     #colferListMax}.
         * @throws InputMismatchException when the data does not match this object's schema.
         */
        public ChatMessage next() throws IOException {
            if (in == null)
                return null;

            while (true) {
                if (this.i > this.offset) {
                    try {
                        ChatMessage o = new ChatMessage();
                        this.offset = o.unmarshal(this.buf, this.offset, this.i);
                        return o;
                    } catch (BufferUnderflowException e) {
                    }
                }
                // not enough data

                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (i == buf.length) {
                    byte[] src = this.buf;
                    // TODO: better size estimation
                    if (offset == 0)
                        this.buf = new byte[Math.min(ChatMessage.colferSizeMax, this.buf.length * 4)];
                    System.arraycopy(src, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert this.i < this.buf.length;

                int n = in.read(buf, i, buf.length - i);
                if (n < 0) {
                    if (this.i > this.offset)
                        throw new InputMismatchException("colfer: pending data with EOF");
                    return null;
                }
                assert n > 0;
                i += n;
            }
        }
    }

    /**
     * Serializes the object.
     * All {@code null} elements in {@link #tokens} will be replaced with a {@code new} value.
     * All {@code null} elements in {@link #badges} will be replaced with a {@code new} value.
     * All {@code null} elements in {@link #message_tags} will be replaced with a {@code new} value.
     * @param out the data destination.
     * @param buf the initial buffer or {@code null}.
     * @return the final buffer. When the serial fits into {@code buf} then the return is {@code buf}.
     *  Otherwise the return is a new buffer, large enough to hold the whole serial.
     * @throws IOException from {@code out}.
     * @throws IllegalStateException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
     *     #colferListMax}.
     */
    public byte[] marshal(OutputStream out, byte[] buf) throws IOException {
        // TODO: better size estimation
        if (buf == null || buf.length == 0)
            buf = new byte[Math.min(ChatMessage.colferSizeMax, 2048)];

        while (true) {
            int i;
            try {
                i = marshal(buf, 0);
            } catch (BufferOverflowException e) {
                buf = new byte[Math.min(ChatMessage.colferSizeMax, buf.length * 4)];
                continue;
            }

            out.write(buf, 0, i);
            return buf;
        }
    }

    /**
     * Serializes the object.
     * All {@code null} elements in {@link #tokens} will be replaced with a {@code new} value.
     * All {@code null} elements in {@link #badges} will be replaced with a {@code new} value.
     * All {@code null} elements in {@link #message_tags} will be replaced with a {@code new} value.
     * @param buf the data destination.
     * @param offset the initial index for {@code buf}, inclusive.
     * @return the final index for {@code buf}, exclusive.
     * @throws BufferOverflowException when {@code buf} is too small.
     * @throws IllegalStateException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
     *     #colferListMax}.
     */
    public int marshal(byte[] buf, int offset) {
        int i = offset;

        try {
            if (!this.message_id.isEmpty()) {
                buf[i++] = (byte) 0;
                int start = ++i;

                String s = this.message_id;
                for (int sIndex = 0, sLength = s.length(); sIndex < sLength; sIndex++) {
                    char c = s.charAt(sIndex);
                    if (c < '\u0080') {
                        buf[i++] = (byte) c;
                    } else if (c < '\u0800') {
                        buf[i++] = (byte) (192 | c >>> 6);
                        buf[i++] = (byte) (128 | c & 63);
                    } else if (c < '\ud800' || c > '\udfff') {
                        buf[i++] = (byte) (224 | c >>> 12);
                        buf[i++] = (byte) (128 | c >>> 6 & 63);
                        buf[i++] = (byte) (128 | c & 63);
                    } else {
                        int cp = 0;
                        if (++sIndex < sLength)
                            cp = Character.toCodePoint(c, s.charAt(sIndex));
                        if ((cp >= 1 << 16) && (cp < 1 << 21)) {
                            buf[i++] = (byte) (240 | cp >>> 18);
                            buf[i++] = (byte) (128 | cp >>> 12 & 63);
                            buf[i++] = (byte) (128 | cp >>> 6 & 63);
                            buf[i++] = (byte) (128 | cp & 63);
                        } else
                            buf[i++] = (byte) '?';
                    }
                }
                int size = i - start;
                if (size > ChatMessage.colferSizeMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.message_id size %d exceeds %d UTF-8 bytes",
                            size, ChatMessage.colferSizeMax));

                int ii = start - 1;
                if (size > 0x7f) {
                    i++;
                    for (int x = size; x >= 1 << 14; x >>>= 7)
                        i++;
                    System.arraycopy(buf, start, buf, i - size, size);

                    do {
                        buf[ii++] = (byte) (size | 0x80);
                        size >>>= 7;
                    } while (size > 0x7f);
                }
                buf[ii] = (byte) size;
            }

            if (!this.user_name.isEmpty()) {
                buf[i++] = (byte) 1;
                int start = ++i;

                String s = this.user_name;
                for (int sIndex = 0, sLength = s.length(); sIndex < sLength; sIndex++) {
                    char c = s.charAt(sIndex);
                    if (c < '\u0080') {
                        buf[i++] = (byte) c;
                    } else if (c < '\u0800') {
                        buf[i++] = (byte) (192 | c >>> 6);
                        buf[i++] = (byte) (128 | c & 63);
                    } else if (c < '\ud800' || c > '\udfff') {
                        buf[i++] = (byte) (224 | c >>> 12);
                        buf[i++] = (byte) (128 | c >>> 6 & 63);
                        buf[i++] = (byte) (128 | c & 63);
                    } else {
                        int cp = 0;
                        if (++sIndex < sLength)
                            cp = Character.toCodePoint(c, s.charAt(sIndex));
                        if ((cp >= 1 << 16) && (cp < 1 << 21)) {
                            buf[i++] = (byte) (240 | cp >>> 18);
                            buf[i++] = (byte) (128 | cp >>> 12 & 63);
                            buf[i++] = (byte) (128 | cp >>> 6 & 63);
                            buf[i++] = (byte) (128 | cp & 63);
                        } else
                            buf[i++] = (byte) '?';
                    }
                }
                int size = i - start;
                if (size > ChatMessage.colferSizeMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.user_name size %d exceeds %d UTF-8 bytes",
                            size, ChatMessage.colferSizeMax));

                int ii = start - 1;
                if (size > 0x7f) {
                    i++;
                    for (int x = size; x >= 1 << 14; x >>>= 7)
                        i++;
                    System.arraycopy(buf, start, buf, i - size, size);

                    do {
                        buf[ii++] = (byte) (size | 0x80);
                        size >>>= 7;
                    } while (size > 0x7f);
                }
                buf[ii] = (byte) size;
            }

            if (!this.display_name.isEmpty()) {
                buf[i++] = (byte) 2;
                int start = ++i;

                String s = this.display_name;
                for (int sIndex = 0, sLength = s.length(); sIndex < sLength; sIndex++) {
                    char c = s.charAt(sIndex);
                    if (c < '\u0080') {
                        buf[i++] = (byte) c;
                    } else if (c < '\u0800') {
                        buf[i++] = (byte) (192 | c >>> 6);
                        buf[i++] = (byte) (128 | c & 63);
                    } else if (c < '\ud800' || c > '\udfff') {
                        buf[i++] = (byte) (224 | c >>> 12);
                        buf[i++] = (byte) (128 | c >>> 6 & 63);
                        buf[i++] = (byte) (128 | c & 63);
                    } else {
                        int cp = 0;
                        if (++sIndex < sLength)
                            cp = Character.toCodePoint(c, s.charAt(sIndex));
                        if ((cp >= 1 << 16) && (cp < 1 << 21)) {
                            buf[i++] = (byte) (240 | cp >>> 18);
                            buf[i++] = (byte) (128 | cp >>> 12 & 63);
                            buf[i++] = (byte) (128 | cp >>> 6 & 63);
                            buf[i++] = (byte) (128 | cp & 63);
                        } else
                            buf[i++] = (byte) '?';
                    }
                }
                int size = i - start;
                if (size > ChatMessage.colferSizeMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.display_name size %d exceeds %d UTF-8 bytes",
                            size, ChatMessage.colferSizeMax));

                int ii = start - 1;
                if (size > 0x7f) {
                    i++;
                    for (int x = size; x >= 1 << 14; x >>>= 7)
                        i++;
                    System.arraycopy(buf, start, buf, i - size, size);

                    do {
                        buf[ii++] = (byte) (size | 0x80);
                        size >>>= 7;
                    } while (size > 0x7f);
                }
                buf[ii] = (byte) size;
            }

            if (!this.message_type.isEmpty()) {
                buf[i++] = (byte) 3;
                int start = ++i;

                String s = this.message_type;
                for (int sIndex = 0, sLength = s.length(); sIndex < sLength; sIndex++) {
                    char c = s.charAt(sIndex);
                    if (c < '\u0080') {
                        buf[i++] = (byte) c;
                    } else if (c < '\u0800') {
                        buf[i++] = (byte) (192 | c >>> 6);
                        buf[i++] = (byte) (128 | c & 63);
                    } else if (c < '\ud800' || c > '\udfff') {
                        buf[i++] = (byte) (224 | c >>> 12);
                        buf[i++] = (byte) (128 | c >>> 6 & 63);
                        buf[i++] = (byte) (128 | c & 63);
                    } else {
                        int cp = 0;
                        if (++sIndex < sLength)
                            cp = Character.toCodePoint(c, s.charAt(sIndex));
                        if ((cp >= 1 << 16) && (cp < 1 << 21)) {
                            buf[i++] = (byte) (240 | cp >>> 18);
                            buf[i++] = (byte) (128 | cp >>> 12 & 63);
                            buf[i++] = (byte) (128 | cp >>> 6 & 63);
                            buf[i++] = (byte) (128 | cp & 63);
                        } else
                            buf[i++] = (byte) '?';
                    }
                }
                int size = i - start;
                if (size > ChatMessage.colferSizeMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.message_type size %d exceeds %d UTF-8 bytes",
                            size, ChatMessage.colferSizeMax));

                int ii = start - 1;
                if (size > 0x7f) {
                    i++;
                    for (int x = size; x >= 1 << 14; x >>>= 7)
                        i++;
                    System.arraycopy(buf, start, buf, i - size, size);

                    do {
                        buf[ii++] = (byte) (size | 0x80);
                        size >>>= 7;
                    } while (size > 0x7f);
                }
                buf[ii] = (byte) size;
            }

            if (this.user_id != 0) {
                int x = this.user_id;
                if ((x & ~((1 << 21) - 1)) != 0) {
                    buf[i++] = (byte) (4 | 0x80);
                    buf[i++] = (byte) (x >>> 24);
                    buf[i++] = (byte) (x >>> 16);
                    buf[i++] = (byte) (x >>> 8);
                } else {
                    buf[i++] = (byte) 4;
                    while (x > 0x7f) {
                        buf[i++] = (byte) (x | 0x80);
                        x >>>= 7;
                    }
                }
                buf[i++] = (byte) x;
            }

            if (this.name_color_argb != 0) {
                int x = this.name_color_argb;
                if ((x & ~((1 << 21) - 1)) != 0) {
                    buf[i++] = (byte) (5 | 0x80);
                    buf[i++] = (byte) (x >>> 24);
                    buf[i++] = (byte) (x >>> 16);
                    buf[i++] = (byte) (x >>> 8);
                } else {
                    buf[i++] = (byte) 5;
                    while (x > 0x7f) {
                        buf[i++] = (byte) (x | 0x80);
                        x >>>= 7;
                    }
                }
                buf[i++] = (byte) x;
            }

            if (this.timestamp != 0) {
                int x = this.timestamp;
                if ((x & ~((1 << 21) - 1)) != 0) {
                    buf[i++] = (byte) (6 | 0x80);
                    buf[i++] = (byte) (x >>> 24);
                    buf[i++] = (byte) (x >>> 16);
                    buf[i++] = (byte) (x >>> 8);
                } else {
                    buf[i++] = (byte) 6;
                    while (x > 0x7f) {
                        buf[i++] = (byte) (x | 0x80);
                        x >>>= 7;
                    }
                }
                buf[i++] = (byte) x;
            }

            if (this.num_bits_sent != 0) {
                int x = this.num_bits_sent;
                if ((x & ~((1 << 21) - 1)) != 0) {
                    buf[i++] = (byte) (7 | 0x80);
                    buf[i++] = (byte) (x >>> 24);
                    buf[i++] = (byte) (x >>> 16);
                    buf[i++] = (byte) (x >>> 8);
                } else {
                    buf[i++] = (byte) 7;
                    while (x > 0x7f) {
                        buf[i++] = (byte) (x | 0x80);
                        x >>>= 7;
                    }
                }
                buf[i++] = (byte) x;
            }

            if (this.usermode_moderator) {
                buf[i++] = (byte) 8;
            }

            if (this.usermode_broadcaster) {
                buf[i++] = (byte) 9;
            }

            if (this.usermode_administrator) {
                buf[i++] = (byte) 10;
            }

            if (this.usermode_staff) {
                buf[i++] = (byte) 11;
            }

            if (this.usermode_system) {
                buf[i++] = (byte) 12;
            }

            if (this.usermode_global_moderator) {
                buf[i++] = (byte) 13;
            }

            if (this.usermode_banned) {
                buf[i++] = (byte) 14;
            }

            if (this.usermode_subscriber) {
                buf[i++] = (byte) 15;
            }

            if (this.usermode_vip) {
                buf[i++] = (byte) 16;
            }

            if (this.messageflags_action) {
                buf[i++] = (byte) 17;
            }

            if (this.messageflags_notice) {
                buf[i++] = (byte) 18;
            }

            if (this.messageflags_ignored) {
                buf[i++] = (byte) 19;
            }

            if (this.messageflags_deleted) {
                buf[i++] = (byte) 20;
            }

            if (this.messageflags_contains_bits) {
                buf[i++] = (byte) 21;
            }

            if (this.tokens.length != 0) {
                buf[i++] = (byte) 22;
                MessageToken[] a = this.tokens;

                int x = a.length;
                if (x > ChatMessage.colferListMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.tokens length %d exceeds %d elements", x,
                            ChatMessage.colferListMax));
                while (x > 0x7f) {
                    buf[i++] = (byte) (x | 0x80);
                    x >>>= 7;
                }
                buf[i++] = (byte) x;

                for (int ai = 0; ai < a.length; ai++) {
                    MessageToken o = a[ai];
                    if (o == null) {
                        o = new MessageToken();
                        a[ai] = o;
                    }
                    i = o.marshal(buf, i);
                }
            }

            if (this.badges.length != 0) {
                buf[i++] = (byte) 23;
                MessageBadge[] a = this.badges;

                int x = a.length;
                if (x > ChatMessage.colferListMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.badges length %d exceeds %d elements", x,
                            ChatMessage.colferListMax));
                while (x > 0x7f) {
                    buf[i++] = (byte) (x | 0x80);
                    x >>>= 7;
                }
                buf[i++] = (byte) x;

                for (int ai = 0; ai < a.length; ai++) {
                    MessageBadge o = a[ai];
                    if (o == null) {
                        o = new MessageBadge();
                        a[ai] = o;
                    }
                    i = o.marshal(buf, i);
                }
            }

            if (this.message_tags.length != 0) {
                buf[i++] = (byte) 24;
                MessageTag[] a = this.message_tags;

                int x = a.length;
                if (x > ChatMessage.colferListMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.message_tags length %d exceeds %d elements",
                            x, ChatMessage.colferListMax));
                while (x > 0x7f) {
                    buf[i++] = (byte) (x | 0x80);
                    x >>>= 7;
                }
                buf[i++] = (byte) x;

                for (int ai = 0; ai < a.length; ai++) {
                    MessageTag o = a[ai];
                    if (o == null) {
                        o = new MessageTag();
                        a[ai] = o;
                    }
                    i = o.marshal(buf, i);
                }
            }

            buf[i++] = (byte) 0x7f;
            return i;
        } catch (ArrayIndexOutOfBoundsException e) {
            if (i - offset > ChatMessage.colferSizeMax)
                throw new IllegalStateException(
                    format("colfer: tv/twitch/chat/Colfer.ChatMessage exceeds %d bytes", ChatMessage.colferSizeMax));
            if (i > buf.length)
                throw new BufferOverflowException();
            throw e;
        }
    }

    /**
     * Deserializes the object.
     * @param buf the data source.
     * @param offset the initial index for {@code buf}, inclusive.
     * @return the final index for {@code buf}, exclusive.
     * @throws BufferUnderflowException when {@code buf} is incomplete. (EOF)
     * @throws SecurityException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
     *     #colferListMax}.
     * @throws InputMismatchException when the data does not match this object's schema.
     */
    public int unmarshal(byte[] buf, int offset) { return unmarshal(buf, offset, buf.length); }

    /**
     * Deserializes the object.
     * @param buf the data source.
     * @param offset the initial index for {@code buf}, inclusive.
     * @param end the index limit for {@code buf}, exclusive.
     * @return the final index for {@code buf}, exclusive.
     * @throws BufferUnderflowException when {@code buf} is incomplete. (EOF)
     * @throws SecurityException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
     *     #colferListMax}.
     * @throws InputMismatchException when the data does not match this object's schema.
     */
    public int unmarshal(byte[] buf, int offset, int end) {
        if (end > buf.length)
            end = buf.length;
        int i = offset;

        try {
            byte header = buf[i++];

            if (header == (byte) 0) {
                int size = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    size |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (size < 0 || size > ChatMessage.colferSizeMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.message_id size %d exceeds %d UTF-8 bytes",
                            size, ChatMessage.colferSizeMax));

                int start = i;
                i += size;
                this.message_id = new String(buf, start, size, Charset.forName("UTF-8"));
                header = buf[i++];
            }

            if (header == (byte) 1) {
                int size = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    size |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (size < 0 || size > ChatMessage.colferSizeMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.user_name size %d exceeds %d UTF-8 bytes",
                            size, ChatMessage.colferSizeMax));

                int start = i;
                i += size;
                this.user_name = new String(buf, start, size, Charset.forName("UTF-8"));
                header = buf[i++];
            }

            if (header == (byte) 2) {
                int size = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    size |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (size < 0 || size > ChatMessage.colferSizeMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.display_name size %d exceeds %d UTF-8 bytes",
                            size, ChatMessage.colferSizeMax));

                int start = i;
                i += size;
                this.display_name = new String(buf, start, size, Charset.forName("UTF-8"));
                header = buf[i++];
            }

            if (header == (byte) 3) {
                int size = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    size |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (size < 0 || size > ChatMessage.colferSizeMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.message_type size %d exceeds %d UTF-8 bytes",
                            size, ChatMessage.colferSizeMax));

                int start = i;
                i += size;
                this.message_type = new String(buf, start, size, Charset.forName("UTF-8"));
                header = buf[i++];
            }

            if (header == (byte) 4) {
                int x = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    x |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                this.user_id = x;
                header = buf[i++];
            } else if (header == (byte) (4 | 0x80)) {
                this.user_id =
                    (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
                header = buf[i++];
            }

            if (header == (byte) 5) {
                int x = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    x |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                this.name_color_argb = x;
                header = buf[i++];
            } else if (header == (byte) (5 | 0x80)) {
                this.name_color_argb =
                    (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
                header = buf[i++];
            }

            if (header == (byte) 6) {
                int x = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    x |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                this.timestamp = x;
                header = buf[i++];
            } else if (header == (byte) (6 | 0x80)) {
                this.timestamp =
                    (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
                header = buf[i++];
            }

            if (header == (byte) 7) {
                int x = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    x |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                this.num_bits_sent = x;
                header = buf[i++];
            } else if (header == (byte) (7 | 0x80)) {
                this.num_bits_sent =
                    (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
                header = buf[i++];
            }

            if (header == (byte) 8) {
                this.usermode_moderator = true;
                header = buf[i++];
            }

            if (header == (byte) 9) {
                this.usermode_broadcaster = true;
                header = buf[i++];
            }

            if (header == (byte) 10) {
                this.usermode_administrator = true;
                header = buf[i++];
            }

            if (header == (byte) 11) {
                this.usermode_staff = true;
                header = buf[i++];
            }

            if (header == (byte) 12) {
                this.usermode_system = true;
                header = buf[i++];
            }

            if (header == (byte) 13) {
                this.usermode_global_moderator = true;
                header = buf[i++];
            }

            if (header == (byte) 14) {
                this.usermode_banned = true;
                header = buf[i++];
            }

            if (header == (byte) 15) {
                this.usermode_subscriber = true;
                header = buf[i++];
            }

            if (header == (byte) 16) {
                this.usermode_vip = true;
                header = buf[i++];
            }

            if (header == (byte) 17) {
                this.messageflags_action = true;
                header = buf[i++];
            }

            if (header == (byte) 18) {
                this.messageflags_notice = true;
                header = buf[i++];
            }

            if (header == (byte) 19) {
                this.messageflags_ignored = true;
                header = buf[i++];
            }

            if (header == (byte) 20) {
                this.messageflags_deleted = true;
                header = buf[i++];
            }

            if (header == (byte) 21) {
                this.messageflags_contains_bits = true;
                header = buf[i++];
            }

            if (header == (byte) 22) {
                int length = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    length |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (length < 0 || length > ChatMessage.colferListMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.tokens length %d exceeds %d elements", length,
                            ChatMessage.colferListMax));

                MessageToken[] a = new MessageToken[length];
                for (int ai = 0; ai < length; ai++) {
                    MessageToken o = new MessageToken();
                    i = o.unmarshal(buf, i, end);
                    a[ai] = o;
                }
                this.tokens = a;
                header = buf[i++];
            }

            if (header == (byte) 23) {
                int length = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    length |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (length < 0 || length > ChatMessage.colferListMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.badges length %d exceeds %d elements", length,
                            ChatMessage.colferListMax));

                MessageBadge[] a = new MessageBadge[length];
                for (int ai = 0; ai < length; ai++) {
                    MessageBadge o = new MessageBadge();
                    i = o.unmarshal(buf, i, end);
                    a[ai] = o;
                }
                this.badges = a;
                header = buf[i++];
            }

            if (header == (byte) 24) {
                int length = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    length |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (length < 0 || length > ChatMessage.colferListMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessage.message_tags length %d exceeds %d elements",
                            length, ChatMessage.colferListMax));

                MessageTag[] a = new MessageTag[length];
                for (int ai = 0; ai < length; ai++) {
                    MessageTag o = new MessageTag();
                    i = o.unmarshal(buf, i, end);
                    a[ai] = o;
                }
                this.message_tags = a;
                header = buf[i++];
            }

            if (header != (byte) 0x7f)
                throw new InputMismatchException(format("colfer: unknown header at byte %d", i - 1));
        } finally {
            if (i > end && end - offset < ChatMessage.colferSizeMax)
                throw new BufferUnderflowException();
            if (i < 0 || i - offset > ChatMessage.colferSizeMax)
                throw new SecurityException(
                    format("colfer: tv/twitch/chat/Colfer.ChatMessage exceeds %d bytes", ChatMessage.colferSizeMax));
            if (i > end)
                throw new BufferUnderflowException();
        }

        return i;
    }

    // {@link Serializable} version number.
    private static final long serialVersionUID = 25L;

    // {@link Serializable} Colfer extension.
    private void writeObject(ObjectOutputStream out) throws IOException {
        // TODO: better size estimation
        byte[] buf = new byte[1024];
        int n;
        while (true)
            try {
                n = marshal(buf, 0);
                break;
            } catch (BufferUnderflowException e) {
                buf = new byte[4 * buf.length];
            }

        out.writeInt(n);
        out.write(buf, 0, n);
    }

    // {@link Serializable} Colfer extension.
    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        init();

        int n = in.readInt();
        byte[] buf = new byte[n];
        in.readFully(buf);
        unmarshal(buf, 0);
    }

    // {@link Serializable} Colfer extension.
    private void readObjectNoData() throws ObjectStreamException { init(); }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.message_id.
     * @return the value.
     */
    public String getMessage_id() { return this.message_id; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.message_id.
     * @param value the replacement.
     */
    public void setMessage_id(String value) { this.message_id = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.message_id.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withMessage_id(String value) {
        this.message_id = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.user_name.
     * @return the value.
     */
    public String getUser_name() { return this.user_name; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.user_name.
     * @param value the replacement.
     */
    public void setUser_name(String value) { this.user_name = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.user_name.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUser_name(String value) {
        this.user_name = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.display_name.
     * @return the value.
     */
    public String getDisplay_name() { return this.display_name; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.display_name.
     * @param value the replacement.
     */
    public void setDisplay_name(String value) { this.display_name = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.display_name.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withDisplay_name(String value) {
        this.display_name = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.message_type.
     * @return the value.
     */
    public String getMessage_type() { return this.message_type; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.message_type.
     * @param value the replacement.
     */
    public void setMessage_type(String value) { this.message_type = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.message_type.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withMessage_type(String value) {
        this.message_type = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.user_id.
     * @return the value.
     */
    public int getUser_id() { return this.user_id; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.user_id.
     * @param value the replacement.
     */
    public void setUser_id(int value) { this.user_id = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.user_id.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUser_id(int value) {
        this.user_id = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.name_color_argb.
     * @return the value.
     */
    public int getName_color_argb() { return this.name_color_argb; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.name_color_argb.
     * @param value the replacement.
     */
    public void setName_color_argb(int value) { this.name_color_argb = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.name_color_argb.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withName_color_argb(int value) {
        this.name_color_argb = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.timestamp.
     * @return the value.
     */
    public int getTimestamp() { return this.timestamp; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.timestamp.
     * @param value the replacement.
     */
    public void setTimestamp(int value) { this.timestamp = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.timestamp.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withTimestamp(int value) {
        this.timestamp = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.num_bits_sent.
     * @return the value.
     */
    public int getNum_bits_sent() { return this.num_bits_sent; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.num_bits_sent.
     * @param value the replacement.
     */
    public void setNum_bits_sent(int value) { this.num_bits_sent = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.num_bits_sent.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withNum_bits_sent(int value) {
        this.num_bits_sent = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.usermode_moderator.
     * @return the value.
     */
    public boolean getUsermode_moderator() { return this.usermode_moderator; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_moderator.
     * @param value the replacement.
     */
    public void setUsermode_moderator(boolean value) { this.usermode_moderator = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_moderator.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUsermode_moderator(boolean value) {
        this.usermode_moderator = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.usermode_broadcaster.
     * @return the value.
     */
    public boolean getUsermode_broadcaster() { return this.usermode_broadcaster; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_broadcaster.
     * @param value the replacement.
     */
    public void setUsermode_broadcaster(boolean value) { this.usermode_broadcaster = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_broadcaster.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUsermode_broadcaster(boolean value) {
        this.usermode_broadcaster = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.usermode_administrator.
     * @return the value.
     */
    public boolean getUsermode_administrator() { return this.usermode_administrator; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_administrator.
     * @param value the replacement.
     */
    public void setUsermode_administrator(boolean value) { this.usermode_administrator = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_administrator.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUsermode_administrator(boolean value) {
        this.usermode_administrator = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.usermode_staff.
     * @return the value.
     */
    public boolean getUsermode_staff() { return this.usermode_staff; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_staff.
     * @param value the replacement.
     */
    public void setUsermode_staff(boolean value) { this.usermode_staff = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_staff.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUsermode_staff(boolean value) {
        this.usermode_staff = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.usermode_system.
     * @return the value.
     */
    public boolean getUsermode_system() { return this.usermode_system; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_system.
     * @param value the replacement.
     */
    public void setUsermode_system(boolean value) { this.usermode_system = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_system.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUsermode_system(boolean value) {
        this.usermode_system = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.usermode_global_moderator.
     * @return the value.
     */
    public boolean getUsermode_global_moderator() { return this.usermode_global_moderator; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_global_moderator.
     * @param value the replacement.
     */
    public void setUsermode_global_moderator(boolean value) { this.usermode_global_moderator = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_global_moderator.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUsermode_global_moderator(boolean value) {
        this.usermode_global_moderator = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.usermode_banned.
     * @return the value.
     */
    public boolean getUsermode_banned() { return this.usermode_banned; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_banned.
     * @param value the replacement.
     */
    public void setUsermode_banned(boolean value) { this.usermode_banned = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_banned.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUsermode_banned(boolean value) {
        this.usermode_banned = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.usermode_subscriber.
     * @return the value.
     */
    public boolean getUsermode_subscriber() { return this.usermode_subscriber; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_subscriber.
     * @param value the replacement.
     */
    public void setUsermode_subscriber(boolean value) { this.usermode_subscriber = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_subscriber.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUsermode_subscriber(boolean value) {
        this.usermode_subscriber = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.usermode_vip.
     * @return the value.
     */
    public boolean getUsermode_vip() { return this.usermode_vip; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_vip.
     * @param value the replacement.
     */
    public void setUsermode_vip(boolean value) { this.usermode_vip = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.usermode_vip.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withUsermode_vip(boolean value) {
        this.usermode_vip = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.messageflags_action.
     * @return the value.
     */
    public boolean getMessageflags_action() { return this.messageflags_action; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_action.
     * @param value the replacement.
     */
    public void setMessageflags_action(boolean value) { this.messageflags_action = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_action.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withMessageflags_action(boolean value) {
        this.messageflags_action = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.messageflags_notice.
     * @return the value.
     */
    public boolean getMessageflags_notice() { return this.messageflags_notice; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_notice.
     * @param value the replacement.
     */
    public void setMessageflags_notice(boolean value) { this.messageflags_notice = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_notice.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withMessageflags_notice(boolean value) {
        this.messageflags_notice = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.messageflags_ignored.
     * @return the value.
     */
    public boolean getMessageflags_ignored() { return this.messageflags_ignored; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_ignored.
     * @param value the replacement.
     */
    public void setMessageflags_ignored(boolean value) { this.messageflags_ignored = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_ignored.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withMessageflags_ignored(boolean value) {
        this.messageflags_ignored = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.messageflags_deleted.
     * @return the value.
     */
    public boolean getMessageflags_deleted() { return this.messageflags_deleted; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_deleted.
     * @param value the replacement.
     */
    public void setMessageflags_deleted(boolean value) { this.messageflags_deleted = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_deleted.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withMessageflags_deleted(boolean value) {
        this.messageflags_deleted = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.messageflags_contains_bits.
     * @return the value.
     */
    public boolean getMessageflags_contains_bits() { return this.messageflags_contains_bits; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_contains_bits.
     * @param value the replacement.
     */
    public void setMessageflags_contains_bits(boolean value) { this.messageflags_contains_bits = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.messageflags_contains_bits.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withMessageflags_contains_bits(boolean value) {
        this.messageflags_contains_bits = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.tokens.
     * @return the value.
     */
    public MessageToken[] getTokens() { return this.tokens; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.tokens.
     * @param value the replacement.
     */
    public void setTokens(MessageToken[] value) { this.tokens = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.tokens.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withTokens(MessageToken[] value) {
        this.tokens = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.badges.
     * @return the value.
     */
    public MessageBadge[] getBadges() { return this.badges; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.badges.
     * @param value the replacement.
     */
    public void setBadges(MessageBadge[] value) { this.badges = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.badges.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withBadges(MessageBadge[] value) {
        this.badges = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessage.message_tags.
     * @return the value.
     */
    public MessageTag[] getMessage_tags() { return this.message_tags; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.message_tags.
     * @param value the replacement.
     */
    public void setMessage_tags(MessageTag[] value) { this.message_tags = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessage.message_tags.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessage withMessage_tags(MessageTag[] value) {
        this.message_tags = value;
        return this;
    }

    @Override
    public final int hashCode() {
        int h = 1;
        if (this.message_id != null)
            h = 31 * h + this.message_id.hashCode();
        if (this.user_name != null)
            h = 31 * h + this.user_name.hashCode();
        if (this.display_name != null)
            h = 31 * h + this.display_name.hashCode();
        if (this.message_type != null)
            h = 31 * h + this.message_type.hashCode();
        h = 31 * h + this.user_id;
        h = 31 * h + this.name_color_argb;
        h = 31 * h + this.timestamp;
        h = 31 * h + this.num_bits_sent;
        h = 31 * h + (this.usermode_moderator ? 1231 : 1237);
        h = 31 * h + (this.usermode_broadcaster ? 1231 : 1237);
        h = 31 * h + (this.usermode_administrator ? 1231 : 1237);
        h = 31 * h + (this.usermode_staff ? 1231 : 1237);
        h = 31 * h + (this.usermode_system ? 1231 : 1237);
        h = 31 * h + (this.usermode_global_moderator ? 1231 : 1237);
        h = 31 * h + (this.usermode_banned ? 1231 : 1237);
        h = 31 * h + (this.usermode_subscriber ? 1231 : 1237);
        h = 31 * h + (this.usermode_vip ? 1231 : 1237);
        h = 31 * h + (this.messageflags_action ? 1231 : 1237);
        h = 31 * h + (this.messageflags_notice ? 1231 : 1237);
        h = 31 * h + (this.messageflags_ignored ? 1231 : 1237);
        h = 31 * h + (this.messageflags_deleted ? 1231 : 1237);
        h = 31 * h + (this.messageflags_contains_bits ? 1231 : 1237);
        for (MessageToken o : this.tokens)
            h = 31 * h + (o == null ? 0 : o.hashCode());
        for (MessageBadge o : this.badges)
            h = 31 * h + (o == null ? 0 : o.hashCode());
        for (MessageTag o : this.message_tags)
            h = 31 * h + (o == null ? 0 : o.hashCode());
        return h;
    }

    @Override
    public final boolean equals(Object o) {
        return o instanceof ChatMessage && equals((ChatMessage) o);
    }

    public final boolean equals(ChatMessage o) {
        if (o == null)
            return false;
        if (o == this)
            return true;
        return o.getClass() == ChatMessage.class
            && (this.message_id == null ? o.message_id == null : this.message_id.equals(o.message_id))
            && (this.user_name == null ? o.user_name == null : this.user_name.equals(o.user_name))
            && (this.display_name == null ? o.display_name == null : this.display_name.equals(o.display_name))
            && (this.message_type == null ? o.message_type == null : this.message_type.equals(o.message_type))
            && this.user_id == o.user_id && this.name_color_argb == o.name_color_argb && this.timestamp == o.timestamp
            && this.num_bits_sent == o.num_bits_sent && this.usermode_moderator == o.usermode_moderator
            && this.usermode_broadcaster == o.usermode_broadcaster
            && this.usermode_administrator == o.usermode_administrator && this.usermode_staff == o.usermode_staff
            && this.usermode_system == o.usermode_system
            && this.usermode_global_moderator == o.usermode_global_moderator
            && this.usermode_banned == o.usermode_banned && this.usermode_subscriber == o.usermode_subscriber
            && this.usermode_vip == o.usermode_vip && this.messageflags_action == o.messageflags_action
            && this.messageflags_notice == o.messageflags_notice && this.messageflags_ignored == o.messageflags_ignored
            && this.messageflags_deleted == o.messageflags_deleted
            && this.messageflags_contains_bits == o.messageflags_contains_bits
            && java.util.Arrays.equals(this.tokens, o.tokens) && java.util.Arrays.equals(this.badges, o.badges)
            && java.util.Arrays.equals(this.message_tags, o.message_tags);
    }
}
