package tv.twitch.chat.colfer;

// Code generated by colf(1); DO NOT EDIT.

import static java.lang.String.format;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.InputMismatchException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * Data bean with built-in serialization support.

 * @author generated by colf(1)
 * @see <a href="https://github.com/pascaldekloe/colfer">Colfer's home</a>
 */
public class ChatMessageArray implements Serializable {
    /** The upper limit for serial byte sizes. */
    public static int colferSizeMax = 16 * 1024 * 1024;

    /** The upper limit for the number of elements in a list. */
    public static int colferListMax = 64 * 1024;

    public ChatMessage[] messages;

    /** Default constructor */
    public ChatMessageArray() { init(); }

    private static final ChatMessage[] _zeroMessages = new ChatMessage[0];

    /** Colfer zero values. */
    private void init() { messages = _zeroMessages; }

    /**
     * {@link #reset(InputStream) Reusable} deserialization of Colfer streams.
     */
    public static class Unmarshaller {
        /** The data source. */
        protected InputStream in;

        /** The read buffer. */
        public byte[] buf;

        /** The {@link #buf buffer}'s data start index, inclusive. */
        protected int offset;

        /** The {@link #buf buffer}'s data end index, exclusive. */
        protected int i;

        /**
         * @param in the data source or {@code null}.
         * @param buf the initial buffer or {@code null}.
         */
        public Unmarshaller(InputStream in, byte[] buf) {
            // TODO: better size estimation
            if (buf == null || buf.length == 0)
                buf = new byte[Math.min(ChatMessageArray.colferSizeMax, 2048)];
            this.buf = buf;
            reset(in);
        }

        /**
         * Reuses the marshaller.
         * @param in the data source or {@code null}.
         * @throws IllegalStateException on pending data.
         */
        public void reset(InputStream in) {
            if (this.i != this.offset)
                throw new IllegalStateException("colfer: pending data");
            this.in = in;
            this.offset = 0;
            this.i = 0;
        }

        /**
         * Deserializes the following object.
         * @return the result or {@code null} when EOF.
         * @throws IOException from the input stream.
         * @throws SecurityException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
         *     #colferListMax}.
         * @throws InputMismatchException when the data does not match this object's schema.
         */
        public ChatMessageArray next() throws IOException {
            if (in == null)
                return null;

            while (true) {
                if (this.i > this.offset) {
                    try {
                        ChatMessageArray o = new ChatMessageArray();
                        this.offset = o.unmarshal(this.buf, this.offset, this.i);
                        return o;
                    } catch (BufferUnderflowException e) {
                    }
                }
                // not enough data

                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (i == buf.length) {
                    byte[] src = this.buf;
                    // TODO: better size estimation
                    if (offset == 0)
                        this.buf = new byte[Math.min(ChatMessageArray.colferSizeMax, this.buf.length * 4)];
                    System.arraycopy(src, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert this.i < this.buf.length;

                int n = in.read(buf, i, buf.length - i);
                if (n < 0) {
                    if (this.i > this.offset)
                        throw new InputMismatchException("colfer: pending data with EOF");
                    return null;
                }
                assert n > 0;
                i += n;
            }
        }
    }

    /**
     * Serializes the object.
     * All {@code null} elements in {@link #messages} will be replaced with a {@code new} value.
     * @param out the data destination.
     * @param buf the initial buffer or {@code null}.
     * @return the final buffer. When the serial fits into {@code buf} then the return is {@code buf}.
     *  Otherwise the return is a new buffer, large enough to hold the whole serial.
     * @throws IOException from {@code out}.
     * @throws IllegalStateException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
     *     #colferListMax}.
     */
    public byte[] marshal(OutputStream out, byte[] buf) throws IOException {
        // TODO: better size estimation
        if (buf == null || buf.length == 0)
            buf = new byte[Math.min(ChatMessageArray.colferSizeMax, 2048)];

        while (true) {
            int i;
            try {
                i = marshal(buf, 0);
            } catch (BufferOverflowException e) {
                buf = new byte[Math.min(ChatMessageArray.colferSizeMax, buf.length * 4)];
                continue;
            }

            out.write(buf, 0, i);
            return buf;
        }
    }

    /**
     * Serializes the object.
     * All {@code null} elements in {@link #messages} will be replaced with a {@code new} value.
     * @param buf the data destination.
     * @param offset the initial index for {@code buf}, inclusive.
     * @return the final index for {@code buf}, exclusive.
     * @throws BufferOverflowException when {@code buf} is too small.
     * @throws IllegalStateException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
     *     #colferListMax}.
     */
    public int marshal(byte[] buf, int offset) {
        int i = offset;

        try {
            if (this.messages.length != 0) {
                buf[i++] = (byte) 0;
                ChatMessage[] a = this.messages;

                int x = a.length;
                if (x > ChatMessageArray.colferListMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessageArray.messages length %d exceeds %d elements",
                            x, ChatMessageArray.colferListMax));
                while (x > 0x7f) {
                    buf[i++] = (byte) (x | 0x80);
                    x >>>= 7;
                }
                buf[i++] = (byte) x;

                for (int ai = 0; ai < a.length; ai++) {
                    ChatMessage o = a[ai];
                    if (o == null) {
                        o = new ChatMessage();
                        a[ai] = o;
                    }
                    i = o.marshal(buf, i);
                }
            }

            buf[i++] = (byte) 0x7f;
            return i;
        } catch (ArrayIndexOutOfBoundsException e) {
            if (i - offset > ChatMessageArray.colferSizeMax)
                throw new IllegalStateException(format(
                    "colfer: tv/twitch/chat/Colfer.ChatMessageArray exceeds %d bytes", ChatMessageArray.colferSizeMax));
            if (i > buf.length)
                throw new BufferOverflowException();
            throw e;
        }
    }

    /**
     * Deserializes the object.
     * @param buf the data source.
     * @param offset the initial index for {@code buf}, inclusive.
     * @return the final index for {@code buf}, exclusive.
     * @throws BufferUnderflowException when {@code buf} is incomplete. (EOF)
     * @throws SecurityException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
     *     #colferListMax}.
     * @throws InputMismatchException when the data does not match this object's schema.
     */
    public int unmarshal(byte[] buf, int offset) { return unmarshal(buf, offset, buf.length); }

    /**
     * Deserializes the object.
     * @param buf the data source.
     * @param offset the initial index for {@code buf}, inclusive.
     * @param end the index limit for {@code buf}, exclusive.
     * @return the final index for {@code buf}, exclusive.
     * @throws BufferUnderflowException when {@code buf} is incomplete. (EOF)
     * @throws SecurityException on an upper limit breach defined by either {@link #colferSizeMax} or {@link
     *     #colferListMax}.
     * @throws InputMismatchException when the data does not match this object's schema.
     */
    public int unmarshal(byte[] buf, int offset, int end) {
        if (end > buf.length)
            end = buf.length;
        int i = offset;

        try {
            byte header = buf[i++];

            if (header == (byte) 0) {
                int length = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    length |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (length < 0 || length > ChatMessageArray.colferListMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.ChatMessageArray.messages length %d exceeds %d elements",
                            length, ChatMessageArray.colferListMax));

                ChatMessage[] a = new ChatMessage[length];
                for (int ai = 0; ai < length; ai++) {
                    ChatMessage o = new ChatMessage();
                    i = o.unmarshal(buf, i, end);
                    a[ai] = o;
                }
                this.messages = a;
                header = buf[i++];
            }

            if (header != (byte) 0x7f)
                throw new InputMismatchException(format("colfer: unknown header at byte %d", i - 1));
        } finally {
            if (i > end && end - offset < ChatMessageArray.colferSizeMax)
                throw new BufferUnderflowException();
            if (i < 0 || i - offset > ChatMessageArray.colferSizeMax)
                throw new SecurityException(format(
                    "colfer: tv/twitch/chat/Colfer.ChatMessageArray exceeds %d bytes", ChatMessageArray.colferSizeMax));
            if (i > end)
                throw new BufferUnderflowException();
        }

        return i;
    }

    // {@link Serializable} version number.
    private static final long serialVersionUID = 1L;

    // {@link Serializable} Colfer extension.
    private void writeObject(ObjectOutputStream out) throws IOException {
        // TODO: better size estimation
        byte[] buf = new byte[1024];
        int n;
        while (true)
            try {
                n = marshal(buf, 0);
                break;
            } catch (BufferUnderflowException e) {
                buf = new byte[4 * buf.length];
            }

        out.writeInt(n);
        out.write(buf, 0, n);
    }

    // {@link Serializable} Colfer extension.
    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        init();

        int n = in.readInt();
        byte[] buf = new byte[n];
        in.readFully(buf);
        unmarshal(buf, 0);
    }

    // {@link Serializable} Colfer extension.
    private void readObjectNoData() throws ObjectStreamException { init(); }

    /**
     * Gets tv/twitch/chat/Colfer.ChatMessageArray.messages.
     * @return the value.
     */
    public ChatMessage[] getMessages() { return this.messages; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessageArray.messages.
     * @param value the replacement.
     */
    public void setMessages(ChatMessage[] value) { this.messages = value; }

    /**
     * Sets tv/twitch/chat/Colfer.ChatMessageArray.messages.
     * @param value the replacement.
     * @return {link this}.
     */
    public ChatMessageArray withMessages(ChatMessage[] value) {
        this.messages = value;
        return this;
    }

    @Override
    public final int hashCode() {
        int h = 1;
        for (ChatMessage o : this.messages)
            h = 31 * h + (o == null ? 0 : o.hashCode());
        return h;
    }

    @Override
    public final boolean equals(Object o) {
        return o instanceof ChatMessageArray && equals((ChatMessageArray) o);
    }

    public final boolean equals(ChatMessageArray o) {
        if (o == null)
            return false;
        if (o == this)
            return true;
        return o.getClass() == ChatMessageArray.class && java.util.Arrays.equals(this.messages, o.messages);
    }
}
