package tv.twitch.chat.colfer;

// Code generated by colf(1); DO NOT EDIT.

import static java.lang.String.format;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.InputMismatchException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

/**
 * Data bean with built-in serialization support.

 * @author generated by colf(1)
 * @see <a href="https://github.com/pascaldekloe/colfer">Colfer's home</a>
 */
public class MessageToken implements Serializable {
    /** The upper limit for serial byte sizes. */
    public static int colferSizeMax = 16 * 1024 * 1024;

    public byte token_type;

    public String text_field_1;

    public String text_field_2;

    public int num_field;

    public int aggressive_level;

    public int identity_level;

    public int profanity_level;

    public int sexual_level;

    public boolean bool_field;

    /** Default constructor */
    public MessageToken() { init(); }

    /** Colfer zero values. */
    private void init() {
        text_field_1 = "";
        text_field_2 = "";
    }

    /**
     * {@link #reset(InputStream) Reusable} deserialization of Colfer streams.
     */
    public static class Unmarshaller {
        /** The data source. */
        protected InputStream in;

        /** The read buffer. */
        public byte[] buf;

        /** The {@link #buf buffer}'s data start index, inclusive. */
        protected int offset;

        /** The {@link #buf buffer}'s data end index, exclusive. */
        protected int i;

        /**
         * @param in the data source or {@code null}.
         * @param buf the initial buffer or {@code null}.
         */
        public Unmarshaller(InputStream in, byte[] buf) {
            // TODO: better size estimation
            if (buf == null || buf.length == 0)
                buf = new byte[Math.min(MessageToken.colferSizeMax, 2048)];
            this.buf = buf;
            reset(in);
        }

        /**
         * Reuses the marshaller.
         * @param in the data source or {@code null}.
         * @throws IllegalStateException on pending data.
         */
        public void reset(InputStream in) {
            if (this.i != this.offset)
                throw new IllegalStateException("colfer: pending data");
            this.in = in;
            this.offset = 0;
            this.i = 0;
        }

        /**
         * Deserializes the following object.
         * @return the result or {@code null} when EOF.
         * @throws IOException from the input stream.
         * @throws SecurityException on an upper limit breach defined by {@link #colferSizeMax}.
         * @throws InputMismatchException when the data does not match this object's schema.
         */
        public MessageToken next() throws IOException {
            if (in == null)
                return null;

            while (true) {
                if (this.i > this.offset) {
                    try {
                        MessageToken o = new MessageToken();
                        this.offset = o.unmarshal(this.buf, this.offset, this.i);
                        return o;
                    } catch (BufferUnderflowException e) {
                    }
                }
                // not enough data

                if (this.i <= this.offset) {
                    this.offset = 0;
                    this.i = 0;
                } else if (i == buf.length) {
                    byte[] src = this.buf;
                    // TODO: better size estimation
                    if (offset == 0)
                        this.buf = new byte[Math.min(MessageToken.colferSizeMax, this.buf.length * 4)];
                    System.arraycopy(src, this.offset, this.buf, 0, this.i - this.offset);
                    this.i -= this.offset;
                    this.offset = 0;
                }
                assert this.i < this.buf.length;

                int n = in.read(buf, i, buf.length - i);
                if (n < 0) {
                    if (this.i > this.offset)
                        throw new InputMismatchException("colfer: pending data with EOF");
                    return null;
                }
                assert n > 0;
                i += n;
            }
        }
    }

    /**
     * Serializes the object.
     * @param out the data destination.
     * @param buf the initial buffer or {@code null}.
     * @return the final buffer. When the serial fits into {@code buf} then the return is {@code buf}.
     *  Otherwise the return is a new buffer, large enough to hold the whole serial.
     * @throws IOException from {@code out}.
     * @throws IllegalStateException on an upper limit breach defined by {@link #colferSizeMax}.
     */
    public byte[] marshal(OutputStream out, byte[] buf) throws IOException {
        // TODO: better size estimation
        if (buf == null || buf.length == 0)
            buf = new byte[Math.min(MessageToken.colferSizeMax, 2048)];

        while (true) {
            int i;
            try {
                i = marshal(buf, 0);
            } catch (BufferOverflowException e) {
                buf = new byte[Math.min(MessageToken.colferSizeMax, buf.length * 4)];
                continue;
            }

            out.write(buf, 0, i);
            return buf;
        }
    }

    /**
     * Serializes the object.
     * @param buf the data destination.
     * @param offset the initial index for {@code buf}, inclusive.
     * @return the final index for {@code buf}, exclusive.
     * @throws BufferOverflowException when {@code buf} is too small.
     * @throws IllegalStateException on an upper limit breach defined by {@link #colferSizeMax}.
     */
    public int marshal(byte[] buf, int offset) {
        int i = offset;

        try {
            if (this.token_type != 0) {
                buf[i++] = (byte) 0;
                buf[i++] = this.token_type;
            }

            if (!this.text_field_1.isEmpty()) {
                buf[i++] = (byte) 1;
                int start = ++i;

                String s = this.text_field_1;
                for (int sIndex = 0, sLength = s.length(); sIndex < sLength; sIndex++) {
                    char c = s.charAt(sIndex);
                    if (c < '\u0080') {
                        buf[i++] = (byte) c;
                    } else if (c < '\u0800') {
                        buf[i++] = (byte) (192 | c >>> 6);
                        buf[i++] = (byte) (128 | c & 63);
                    } else if (c < '\ud800' || c > '\udfff') {
                        buf[i++] = (byte) (224 | c >>> 12);
                        buf[i++] = (byte) (128 | c >>> 6 & 63);
                        buf[i++] = (byte) (128 | c & 63);
                    } else {
                        int cp = 0;
                        if (++sIndex < sLength)
                            cp = Character.toCodePoint(c, s.charAt(sIndex));
                        if ((cp >= 1 << 16) && (cp < 1 << 21)) {
                            buf[i++] = (byte) (240 | cp >>> 18);
                            buf[i++] = (byte) (128 | cp >>> 12 & 63);
                            buf[i++] = (byte) (128 | cp >>> 6 & 63);
                            buf[i++] = (byte) (128 | cp & 63);
                        } else
                            buf[i++] = (byte) '?';
                    }
                }
                int size = i - start;
                if (size > MessageToken.colferSizeMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.MessageToken.text_field_1 size %d exceeds %d UTF-8 bytes",
                            size, MessageToken.colferSizeMax));

                int ii = start - 1;
                if (size > 0x7f) {
                    i++;
                    for (int x = size; x >= 1 << 14; x >>>= 7)
                        i++;
                    System.arraycopy(buf, start, buf, i - size, size);

                    do {
                        buf[ii++] = (byte) (size | 0x80);
                        size >>>= 7;
                    } while (size > 0x7f);
                }
                buf[ii] = (byte) size;
            }

            if (!this.text_field_2.isEmpty()) {
                buf[i++] = (byte) 2;
                int start = ++i;

                String s = this.text_field_2;
                for (int sIndex = 0, sLength = s.length(); sIndex < sLength; sIndex++) {
                    char c = s.charAt(sIndex);
                    if (c < '\u0080') {
                        buf[i++] = (byte) c;
                    } else if (c < '\u0800') {
                        buf[i++] = (byte) (192 | c >>> 6);
                        buf[i++] = (byte) (128 | c & 63);
                    } else if (c < '\ud800' || c > '\udfff') {
                        buf[i++] = (byte) (224 | c >>> 12);
                        buf[i++] = (byte) (128 | c >>> 6 & 63);
                        buf[i++] = (byte) (128 | c & 63);
                    } else {
                        int cp = 0;
                        if (++sIndex < sLength)
                            cp = Character.toCodePoint(c, s.charAt(sIndex));
                        if ((cp >= 1 << 16) && (cp < 1 << 21)) {
                            buf[i++] = (byte) (240 | cp >>> 18);
                            buf[i++] = (byte) (128 | cp >>> 12 & 63);
                            buf[i++] = (byte) (128 | cp >>> 6 & 63);
                            buf[i++] = (byte) (128 | cp & 63);
                        } else
                            buf[i++] = (byte) '?';
                    }
                }
                int size = i - start;
                if (size > MessageToken.colferSizeMax)
                    throw new IllegalStateException(
                        format("colfer: tv/twitch/chat/Colfer.MessageToken.text_field_2 size %d exceeds %d UTF-8 bytes",
                            size, MessageToken.colferSizeMax));

                int ii = start - 1;
                if (size > 0x7f) {
                    i++;
                    for (int x = size; x >= 1 << 14; x >>>= 7)
                        i++;
                    System.arraycopy(buf, start, buf, i - size, size);

                    do {
                        buf[ii++] = (byte) (size | 0x80);
                        size >>>= 7;
                    } while (size > 0x7f);
                }
                buf[ii] = (byte) size;
            }

            if (this.num_field != 0) {
                int x = this.num_field;
                if ((x & ~((1 << 21) - 1)) != 0) {
                    buf[i++] = (byte) (3 | 0x80);
                    buf[i++] = (byte) (x >>> 24);
                    buf[i++] = (byte) (x >>> 16);
                    buf[i++] = (byte) (x >>> 8);
                } else {
                    buf[i++] = (byte) 3;
                    while (x > 0x7f) {
                        buf[i++] = (byte) (x | 0x80);
                        x >>>= 7;
                    }
                }
                buf[i++] = (byte) x;
            }

            if (this.aggressive_level != 0) {
                int x = this.aggressive_level;
                if ((x & ~((1 << 21) - 1)) != 0) {
                    buf[i++] = (byte) (4 | 0x80);
                    buf[i++] = (byte) (x >>> 24);
                    buf[i++] = (byte) (x >>> 16);
                    buf[i++] = (byte) (x >>> 8);
                } else {
                    buf[i++] = (byte) 4;
                    while (x > 0x7f) {
                        buf[i++] = (byte) (x | 0x80);
                        x >>>= 7;
                    }
                }
                buf[i++] = (byte) x;
            }

            if (this.identity_level != 0) {
                int x = this.identity_level;
                if ((x & ~((1 << 21) - 1)) != 0) {
                    buf[i++] = (byte) (5 | 0x80);
                    buf[i++] = (byte) (x >>> 24);
                    buf[i++] = (byte) (x >>> 16);
                    buf[i++] = (byte) (x >>> 8);
                } else {
                    buf[i++] = (byte) 5;
                    while (x > 0x7f) {
                        buf[i++] = (byte) (x | 0x80);
                        x >>>= 7;
                    }
                }
                buf[i++] = (byte) x;
            }

            if (this.profanity_level != 0) {
                int x = this.profanity_level;
                if ((x & ~((1 << 21) - 1)) != 0) {
                    buf[i++] = (byte) (6 | 0x80);
                    buf[i++] = (byte) (x >>> 24);
                    buf[i++] = (byte) (x >>> 16);
                    buf[i++] = (byte) (x >>> 8);
                } else {
                    buf[i++] = (byte) 6;
                    while (x > 0x7f) {
                        buf[i++] = (byte) (x | 0x80);
                        x >>>= 7;
                    }
                }
                buf[i++] = (byte) x;
            }

            if (this.sexual_level != 0) {
                int x = this.sexual_level;
                if ((x & ~((1 << 21) - 1)) != 0) {
                    buf[i++] = (byte) (7 | 0x80);
                    buf[i++] = (byte) (x >>> 24);
                    buf[i++] = (byte) (x >>> 16);
                    buf[i++] = (byte) (x >>> 8);
                } else {
                    buf[i++] = (byte) 7;
                    while (x > 0x7f) {
                        buf[i++] = (byte) (x | 0x80);
                        x >>>= 7;
                    }
                }
                buf[i++] = (byte) x;
            }

            if (this.bool_field) {
                buf[i++] = (byte) 8;
            }

            buf[i++] = (byte) 0x7f;
            return i;
        } catch (ArrayIndexOutOfBoundsException e) {
            if (i - offset > MessageToken.colferSizeMax)
                throw new IllegalStateException(
                    format("colfer: tv/twitch/chat/Colfer.MessageToken exceeds %d bytes", MessageToken.colferSizeMax));
            if (i > buf.length)
                throw new BufferOverflowException();
            throw e;
        }
    }

    /**
     * Deserializes the object.
     * @param buf the data source.
     * @param offset the initial index for {@code buf}, inclusive.
     * @return the final index for {@code buf}, exclusive.
     * @throws BufferUnderflowException when {@code buf} is incomplete. (EOF)
     * @throws SecurityException on an upper limit breach defined by {@link #colferSizeMax}.
     * @throws InputMismatchException when the data does not match this object's schema.
     */
    public int unmarshal(byte[] buf, int offset) { return unmarshal(buf, offset, buf.length); }

    /**
     * Deserializes the object.
     * @param buf the data source.
     * @param offset the initial index for {@code buf}, inclusive.
     * @param end the index limit for {@code buf}, exclusive.
     * @return the final index for {@code buf}, exclusive.
     * @throws BufferUnderflowException when {@code buf} is incomplete. (EOF)
     * @throws SecurityException on an upper limit breach defined by {@link #colferSizeMax}.
     * @throws InputMismatchException when the data does not match this object's schema.
     */
    public int unmarshal(byte[] buf, int offset, int end) {
        if (end > buf.length)
            end = buf.length;
        int i = offset;

        try {
            byte header = buf[i++];

            if (header == (byte) 0) {
                this.token_type = buf[i++];
                header = buf[i++];
            }

            if (header == (byte) 1) {
                int size = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    size |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (size < 0 || size > MessageToken.colferSizeMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.MessageToken.text_field_1 size %d exceeds %d UTF-8 bytes",
                            size, MessageToken.colferSizeMax));

                int start = i;
                i += size;
                this.text_field_1 = new String(buf, start, size, StandardCharsets.UTF_8);
                header = buf[i++];
            }

            if (header == (byte) 2) {
                int size = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    size |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                if (size < 0 || size > MessageToken.colferSizeMax)
                    throw new SecurityException(
                        format("colfer: tv/twitch/chat/Colfer.MessageToken.text_field_2 size %d exceeds %d UTF-8 bytes",
                            size, MessageToken.colferSizeMax));

                int start = i;
                i += size;
                this.text_field_2 = new String(buf, start, size, StandardCharsets.UTF_8);
                header = buf[i++];
            }

            if (header == (byte) 3) {
                int x = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    x |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                this.num_field = x;
                header = buf[i++];
            } else if (header == (byte) (3 | 0x80)) {
                this.num_field =
                    (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
                header = buf[i++];
            }

            if (header == (byte) 4) {
                int x = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    x |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                this.aggressive_level = x;
                header = buf[i++];
            } else if (header == (byte) (4 | 0x80)) {
                this.aggressive_level =
                    (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
                header = buf[i++];
            }

            if (header == (byte) 5) {
                int x = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    x |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                this.identity_level = x;
                header = buf[i++];
            } else if (header == (byte) (5 | 0x80)) {
                this.identity_level =
                    (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
                header = buf[i++];
            }

            if (header == (byte) 6) {
                int x = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    x |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                this.profanity_level = x;
                header = buf[i++];
            } else if (header == (byte) (6 | 0x80)) {
                this.profanity_level =
                    (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
                header = buf[i++];
            }

            if (header == (byte) 7) {
                int x = 0;
                for (int shift = 0; true; shift += 7) {
                    byte b = buf[i++];
                    x |= (b & 0x7f) << shift;
                    if (shift == 28 || b >= 0)
                        break;
                }
                this.sexual_level = x;
                header = buf[i++];
            } else if (header == (byte) (7 | 0x80)) {
                this.sexual_level =
                    (buf[i++] & 0xff) << 24 | (buf[i++] & 0xff) << 16 | (buf[i++] & 0xff) << 8 | (buf[i++] & 0xff);
                header = buf[i++];
            }

            if (header == (byte) 8) {
                this.bool_field = true;
                header = buf[i++];
            }

            if (header != (byte) 0x7f)
                throw new InputMismatchException(format("colfer: unknown header at byte %d", i - 1));
        } finally {
            if (i > end && end - offset < MessageToken.colferSizeMax)
                throw new BufferUnderflowException();
            if (i < 0 || i - offset > MessageToken.colferSizeMax)
                throw new SecurityException(
                    format("colfer: tv/twitch/chat/Colfer.MessageToken exceeds %d bytes", MessageToken.colferSizeMax));
            if (i > end)
                throw new BufferUnderflowException();
        }

        return i;
    }

    // {@link Serializable} version number.
    private static final long serialVersionUID = 9L;

    // {@link Serializable} Colfer extension.
    private void writeObject(ObjectOutputStream out) throws IOException {
        // TODO: better size estimation
        byte[] buf = new byte[1024];
        int n;
        while (true)
            try {
                n = marshal(buf, 0);
                break;
            } catch (BufferUnderflowException e) {
                buf = new byte[4 * buf.length];
            }

        out.writeInt(n);
        out.write(buf, 0, n);
    }

    // {@link Serializable} Colfer extension.
    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        init();

        int n = in.readInt();
        byte[] buf = new byte[n];
        in.readFully(buf);
        unmarshal(buf, 0);
    }

    // {@link Serializable} Colfer extension.
    private void readObjectNoData() throws ObjectStreamException { init(); }

    /**
     * Gets tv/twitch/chat/Colfer.MessageToken.token_type.
     * @return the value.
     */
    public byte getToken_type() { return this.token_type; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.token_type.
     * @param value the replacement.
     */
    public void setToken_type(byte value) { this.token_type = value; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.token_type.
     * @param value the replacement.
     * @return {link this}.
     */
    public MessageToken withToken_type(byte value) {
        this.token_type = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.MessageToken.text_field_1.
     * @return the value.
     */
    public String getText_field_1() { return this.text_field_1; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.text_field_1.
     * @param value the replacement.
     */
    public void setText_field_1(String value) { this.text_field_1 = value; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.text_field_1.
     * @param value the replacement.
     * @return {link this}.
     */
    public MessageToken withText_field_1(String value) {
        this.text_field_1 = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.MessageToken.text_field_2.
     * @return the value.
     */
    public String getText_field_2() { return this.text_field_2; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.text_field_2.
     * @param value the replacement.
     */
    public void setText_field_2(String value) { this.text_field_2 = value; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.text_field_2.
     * @param value the replacement.
     * @return {link this}.
     */
    public MessageToken withText_field_2(String value) {
        this.text_field_2 = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.MessageToken.num_field.
     * @return the value.
     */
    public int getNum_field() { return this.num_field; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.num_field.
     * @param value the replacement.
     */
    public void setNum_field(int value) { this.num_field = value; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.num_field.
     * @param value the replacement.
     * @return {link this}.
     */
    public MessageToken withNum_field(int value) {
        this.num_field = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.MessageToken.aggressive_level.
     * @return the value.
     */
    public int getAggressive_level() { return this.aggressive_level; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.aggressive_level.
     * @param value the replacement.
     */
    public void setAggressive_level(int value) { this.aggressive_level = value; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.aggressive_level.
     * @param value the replacement.
     * @return {link this}.
     */
    public MessageToken withAggressive_level(int value) {
        this.aggressive_level = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.MessageToken.identity_level.
     * @return the value.
     */
    public int getIdentity_level() { return this.identity_level; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.identity_level.
     * @param value the replacement.
     */
    public void setIdentity_level(int value) { this.identity_level = value; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.identity_level.
     * @param value the replacement.
     * @return {link this}.
     */
    public MessageToken withIdentity_level(int value) {
        this.identity_level = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.MessageToken.profanity_level.
     * @return the value.
     */
    public int getProfanity_level() { return this.profanity_level; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.profanity_level.
     * @param value the replacement.
     */
    public void setProfanity_level(int value) { this.profanity_level = value; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.profanity_level.
     * @param value the replacement.
     * @return {link this}.
     */
    public MessageToken withProfanity_level(int value) {
        this.profanity_level = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.MessageToken.sexual_level.
     * @return the value.
     */
    public int getSexual_level() { return this.sexual_level; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.sexual_level.
     * @param value the replacement.
     */
    public void setSexual_level(int value) { this.sexual_level = value; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.sexual_level.
     * @param value the replacement.
     * @return {link this}.
     */
    public MessageToken withSexual_level(int value) {
        this.sexual_level = value;
        return this;
    }

    /**
     * Gets tv/twitch/chat/Colfer.MessageToken.bool_field.
     * @return the value.
     */
    public boolean getBool_field() { return this.bool_field; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.bool_field.
     * @param value the replacement.
     */
    public void setBool_field(boolean value) { this.bool_field = value; }

    /**
     * Sets tv/twitch/chat/Colfer.MessageToken.bool_field.
     * @param value the replacement.
     * @return {link this}.
     */
    public MessageToken withBool_field(boolean value) {
        this.bool_field = value;
        return this;
    }

    @Override
    public final int hashCode() {
        int h = 1;
        h = 31 * h + (this.token_type & 0xff);
        if (this.text_field_1 != null)
            h = 31 * h + this.text_field_1.hashCode();
        if (this.text_field_2 != null)
            h = 31 * h + this.text_field_2.hashCode();
        h = 31 * h + this.num_field;
        h = 31 * h + this.aggressive_level;
        h = 31 * h + this.identity_level;
        h = 31 * h + this.profanity_level;
        h = 31 * h + this.sexual_level;
        h = 31 * h + (this.bool_field ? 1231 : 1237);
        return h;
    }

    @Override
    public final boolean equals(Object o) {
        return o instanceof MessageToken && equals((MessageToken) o);
    }

    public final boolean equals(MessageToken o) {
        if (o == null)
            return false;
        if (o == this)
            return true;
        return o.getClass() == MessageToken.class && this.token_type == o.token_type
            && (this.text_field_1 == null ? o.text_field_1 == null : this.text_field_1.equals(o.text_field_1))
            && (this.text_field_2 == null ? o.text_field_2 == null : this.text_field_2.equals(o.text_field_2))
            && this.num_field == o.num_field && this.aggressive_level == o.aggressive_level
            && this.identity_level == o.identity_level && this.profanity_level == o.profanity_level
            && this.sexual_level == o.sexual_level && this.bool_field == o.bool_field;
    }
}
