// Code generated by colf(1); DO NOT EDIT.
// The compiler used schema file sdk_colfer.colf for package Colfer.

#ifndef COLFER_CHATMESSAGEARRAY_H
#define COLFER_CHATMESSAGEARRAY_H

#include <limits.h>
#include <stdint.h>
#include <string.h>

#if CHAR_BIT != 8
#error "octet byte size"
#endif

#ifdef __cplusplus
extern "C" {
#endif


// colfer_size_max is the upper limit for serial octet sizes.
extern size_t colfer_size_max;

// colfer_list_max is the upper limit for the number of elements in a list.
extern size_t colfer_list_max;


// colfer_text is a UTF-8 CLOB.
typedef struct {
    const char*  utf8;
    size_t       len;
} colfer_text;

// colfer_binary is a BLOB.
typedef struct {
    uint8_t* octets;
    size_t   len;
} colfer_binary;


typedef struct colfer_message_token colfer_message_token;

typedef struct colfer_message_badge colfer_message_badge;

typedef struct colfer_message_tag colfer_message_tag;

typedef struct colfer_chat_message colfer_chat_message;

typedef struct colfer_chat_message_array colfer_chat_message_array;



struct colfer_message_token {

    uint8_t token_type;

    colfer_text text_field_1;

    colfer_text text_field_2;

    uint32_t num_field;

    uint32_t aggressive_level;

    uint32_t identity_level;

    uint32_t profanity_level;

    uint32_t sexual_level;

    char bool_field;
};

// colfer_message_token_marshal_len returns the Colfer serial octet size.
// When the return is zero then errno is set to EFBIG to indicate a breach of
// either colfer_size_max or colfer_list_max.
size_t colfer_message_token_marshal_len(const colfer_message_token* o);

// colfer_message_token_marshal encodes o as Colfer into buf and returns the number
// of octets written.
size_t colfer_message_token_marshal(const colfer_message_token* o, uint8_t*buf);

// colfer_message_token_unmarshal decodes data as Colfer into o and returns the
// number of octets read. The data is read up to a maximum of datalen or
// colfer_size_max, whichever occurs first.
// When the return is zero then errno is set to one of the following 3 values:
// EWOULDBLOCK on incomplete data, EFBIG on a breach of either colfer_size_max
// or colfer_list_max and EILSEQ on schema mismatch.
size_t colfer_message_token_unmarshal(colfer_message_token* o, const uint8_t*data, size_t datalen);


struct colfer_message_badge {

    colfer_text name;

    colfer_text version;
};

// colfer_message_badge_marshal_len returns the Colfer serial octet size.
// When the return is zero then errno is set to EFBIG to indicate a breach of
// either colfer_size_max or colfer_list_max.
size_t colfer_message_badge_marshal_len(const colfer_message_badge* o);

// colfer_message_badge_marshal encodes o as Colfer into buf and returns the number
// of octets written.
size_t colfer_message_badge_marshal(const colfer_message_badge* o, uint8_t*buf);

// colfer_message_badge_unmarshal decodes data as Colfer into o and returns the
// number of octets read. The data is read up to a maximum of datalen or
// colfer_size_max, whichever occurs first.
// When the return is zero then errno is set to one of the following 3 values:
// EWOULDBLOCK on incomplete data, EFBIG on a breach of either colfer_size_max
// or colfer_list_max and EILSEQ on schema mismatch.
size_t colfer_message_badge_unmarshal(colfer_message_badge* o, const uint8_t*data, size_t datalen);


struct colfer_message_tag {

    colfer_text key;

    colfer_text value;
};

// colfer_message_tag_marshal_len returns the Colfer serial octet size.
// When the return is zero then errno is set to EFBIG to indicate a breach of
// either colfer_size_max or colfer_list_max.
size_t colfer_message_tag_marshal_len(const colfer_message_tag* o);

// colfer_message_tag_marshal encodes o as Colfer into buf and returns the number
// of octets written.
size_t colfer_message_tag_marshal(const colfer_message_tag* o, uint8_t*buf);

// colfer_message_tag_unmarshal decodes data as Colfer into o and returns the
// number of octets read. The data is read up to a maximum of datalen or
// colfer_size_max, whichever occurs first.
// When the return is zero then errno is set to one of the following 3 values:
// EWOULDBLOCK on incomplete data, EFBIG on a breach of either colfer_size_max
// or colfer_list_max and EILSEQ on schema mismatch.
size_t colfer_message_tag_unmarshal(colfer_message_tag* o, const uint8_t*data, size_t datalen);


struct colfer_chat_message {

    colfer_text message_id;

    colfer_text user_name;

    colfer_text display_name;

    colfer_text message_type;

    uint32_t user_id;

    uint32_t name_color_argb;

    uint32_t timestamp;

    uint32_t num_bits_sent;

    char usermode_moderator;

    char usermode_broadcaster;

    char usermode_administrator;

    char usermode_staff;

    char usermode_system;

    char usermode_global_moderator;

    char usermode_banned;

    char usermode_subscriber;

    char usermode_vip;

    char messageflags_action;

    char messageflags_notice;

    char messageflags_ignored;

    char messageflags_deleted;

    char messageflags_contains_bits;

    struct {
        struct colfer_message_token* list;
        size_t len;
    } tokens;

    struct {
        struct colfer_message_badge* list;
        size_t len;
    } badges;

    struct {
        struct colfer_message_tag* list;
        size_t len;
    } message_tags;
};

// colfer_chat_message_marshal_len returns the Colfer serial octet size.
// When the return is zero then errno is set to EFBIG to indicate a breach of
// either colfer_size_max or colfer_list_max.
size_t colfer_chat_message_marshal_len(const colfer_chat_message* o);

// colfer_chat_message_marshal encodes o as Colfer into buf and returns the number
// of octets written.
size_t colfer_chat_message_marshal(const colfer_chat_message* o, uint8_t*buf);

// colfer_chat_message_unmarshal decodes data as Colfer into o and returns the
// number of octets read. The data is read up to a maximum of datalen or
// colfer_size_max, whichever occurs first.
// When the return is zero then errno is set to one of the following 3 values:
// EWOULDBLOCK on incomplete data, EFBIG on a breach of either colfer_size_max
// or colfer_list_max and EILSEQ on schema mismatch.
size_t colfer_chat_message_unmarshal(colfer_chat_message* o, const uint8_t*data, size_t datalen);


struct colfer_chat_message_array {

    struct {
        struct colfer_chat_message* list;
        size_t len;
    } messages;
};

// colfer_chat_message_array_marshal_len returns the Colfer serial octet size.
// When the return is zero then errno is set to EFBIG to indicate a breach of
// either colfer_size_max or colfer_list_max.
size_t colfer_chat_message_array_marshal_len(const colfer_chat_message_array* o);

// colfer_chat_message_array_marshal encodes o as Colfer into buf and returns the number
// of octets written.
size_t colfer_chat_message_array_marshal(const colfer_chat_message_array* o, uint8_t*buf);

// colfer_chat_message_array_unmarshal decodes data as Colfer into o and returns the
// number of octets read. The data is read up to a maximum of datalen or
// colfer_size_max, whichever occurs first.
// When the return is zero then errno is set to one of the following 3 values:
// EWOULDBLOCK on incomplete data, EFBIG on a breach of either colfer_size_max
// or colfer_list_max and EILSEQ on schema mismatch.
size_t colfer_chat_message_array_unmarshal(colfer_chat_message_array* o, const uint8_t*data, size_t datalen);


#ifdef __cplusplus
} // extern "C"
#endif

#endif
