/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ibitslistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaBitsListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaBitsListenerProxy : public NativeListenerProxy<chat::IBitsListener> {
 public:
  JavaBitsListenerProxy();

 public:
  virtual void UserReceivedBits(const chat::BitsReceivedEvent& bitsReceivedEvent) override;
  virtual void UserSentBits(const chat::BitsSentEvent& bitsSentEvent) override;
  virtual void UserGainedBits(const uint32_t bitsBalance) override;
};
