/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chatlistener.h"
#include "twitchsdk/core/generated/java_all.h"
#include "twitchsdk/core/generated/jni_all.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
using namespace ttv::chat;

namespace binding {
namespace java {
class JavaChatAPIListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaChatAPIListenerProxy : public NativeModuleListener<IChatAPIListener> {
 public:
  JavaChatAPIListenerProxy(jobject jModule);

 public:
  virtual void ChatUserEmoticonSetsChanged(UserId userId, const std::vector<EmoticonSet>& emoticonSets) override;
};
