/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chatlistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
using namespace ttv::chat;

namespace chat {
class ChatAPI;
}

namespace binding {
namespace java {
class JavaChatChannelListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaChatChannelListenerProxy : public NativeListenerProxy<IChatChannelListener> {
 public:
  using ChannelDisconnectedFunc = std::function<void(UserId userId, ChannelId channelId)>;

 public:
  JavaChatChannelListenerProxy();

  void SetChatApi(std::shared_ptr<ChatAPI> api) { mChatApi = api; }
  void SetChannelDisconnectedFunc(ChannelDisconnectedFunc func) { mChannelDisconnectedCallback = func; }

 public:
  virtual void ChatChannelStateChanged(
    UserId userId, ChannelId channelId, ChatChannelState state, TTV_ErrorCode ec) override;
  virtual void ChatChannelInfoChanged(UserId userId, ChannelId channelId, const ChatChannelInfo& channelInfo) override;
  virtual void ChatChannelRestrictionsChanged(
    UserId userId, ChannelId channelId, const ChatChannelRestrictions& restrictions) override;
  virtual void ChatChannelLocalUserChanged(UserId userId, ChannelId channelId, const ChatUserInfo& userInfo) override;
  virtual void ChatChannelMessagesReceived(
    UserId userId, ChannelId channelId, const std::vector<LiveChatMessage>& messageList) override;
  virtual void ChatChannelSubscriptionNoticeReceived(
    UserId userId, ChannelId channelId, const SubscriptionNotice& notice) override;
  virtual void ChatChannelFirstTimeChatterNoticeReceived(
    UserId userId, ChannelId channelId, const FirstTimeChatterNotice& notice) override;
  virtual void ChatChannelRaidNoticeReceived(UserId userId, ChannelId channelId, const RaidNotice& notice) override;
  virtual void ChatChannelUnraidNoticeReceived(UserId userId, ChannelId channelId, const UnraidNotice& notice) override;
  virtual void ChatChannelGenericNoticeReceived(
    UserId userId, ChannelId channelId, const GenericMessageNotice& notice) override;
  virtual void ChatChannelMessagesCleared(UserId userId, ChannelId channelId) override;
  virtual void ChatChannelUserMessagesCleared(UserId userId, ChannelId channelId, UserId clearUserId) override;
  virtual void ChatChannelMessageDeleted(UserId userId, ChannelId channelId, std::string&& messageId,
    std::string&& senderLoginName, std::string&& deletedMessageComment) override;
  virtual void ChatChannelModNoticeUserTimedOut(UserId userId, ChannelId channelId,
    ModerationActionInfo&& modActionInfo, uint32_t timeoutDurationSeconds, std::string&& reason) override;
  virtual void ChatChannelModNoticeUserBanned(
    UserId userId, ChannelId channelId, ModerationActionInfo&& modActionInfo, std::string&& reason) override;
  virtual void ChatChannelModNoticeUserUntimedOut(
    UserId userId, ChannelId channelId, ModerationActionInfo&& modActionInfo) override;
  virtual void ChatChannelModNoticeUserUnbanned(
    UserId userId, ChannelId channelId, ModerationActionInfo&& modActionInfo) override;
  virtual void ChatChannelModNoticeMessageDeleted(UserId userId, ChannelId channelId,
    ModerationActionInfo&& modActionInfo, std::string&& messageId, std::string&& message) override;
  virtual void ChatChannelModNoticeClearChat(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName) override;
  virtual void ChatChannelModNoticeEmoteOnly(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName) override;
  virtual void ChatChannelModNoticeEmoteOnlyOff(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName) override;
  virtual void ChatChannelModNoticeFollowersOnly(UserId userId, ChannelId channelId, UserId modId,
    std::string&& modName, uint32_t minimumFollowingDurationMinutes) override;
  virtual void ChatChannelModNoticeFollowersOnlyOff(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName) override;
  virtual void ChatChannelModNoticeR9K(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName) override;
  virtual void ChatChannelModNoticeR9KOff(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName) override;
  virtual void ChatChannelModNoticeSlow(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName, uint32_t slowModeDurationSeconds) override;
  virtual void ChatChannelModNoticeSlowOff(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName) override;
  virtual void ChatChannelModNoticeSubsOnly(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName) override;
  virtual void ChatChannelModNoticeSubsOnlyOff(
    UserId userId, ChannelId channelId, UserId modId, std::string&& modName) override;
  virtual void ChatChannelHostTargetChanged(
    UserId userId, ChannelId channelId, const std::string& targetChannel, uint32_t numViewers) override;
  virtual void ChatChannelNoticeReceived(UserId userId, ChannelId channelId, const std::string& id,
    const std::map<std::string, std::string>& params) override;
  virtual void AutoModCaughtSentMessage(UserId userId, ChannelId channelId) override;
  virtual void AutoModDeniedSentMessage(UserId userId, ChannelId channelId) override;
  virtual void AutoModApprovedSentMessage(UserId userId, ChannelId channelId) override;
  virtual void AutoModCaughtMessageForMods(UserId userId, ChannelId channelId, std::string&& messageId,
    std::string&& message, UserId senderId, std::string&& senderName, std::string&& reason) override;
  virtual void AutoModMessageApprovedByMod(UserId userId, ChannelId channelId, std::string&& messageId,
    UserId moderatorId, std::string&& moderatorName) override;
  virtual void AutoModMessageDeniedByMod(UserId userId, ChannelId channelId, std::string&& messageId,
    UserId moderatorId, std::string&& moderatorName) override;
  virtual void AutoModDeniedSentCheer(UserId userId, ChannelId channelId) override;
  virtual void AutoModTimedOutSentCheer(UserId userId, ChannelId channelId) override;
  virtual void AutoModCaughtCheerForMods(UserId userId, ChannelId channelId, std::string&& messageId,
    std::string&& message, UserId senderId, std::string&& senderName, std::string&& reason) override;

 private:
  std::weak_ptr<ChatAPI> mChatApi;
  ChannelDisconnectedFunc mChannelDisconnectedCallback;
};
