/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chatmessagehandler.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

#include <string>

namespace ttv {
namespace binding {
namespace java {
class JavaChatMessageHandlerCallbacksProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaChatMessageHandlerCallbacksProxy
    : public NativeListenerProxy<chat::ChatMessageHandler::ICallbacks> {
 public:
  JavaChatMessageHandlerCallbacksProxy();

 public:
  virtual bool PassThrough(const std::string& message) override;
  virtual bool BlockUser(const std::string& blockUserName) override;
  virtual bool UnblockUser(const std::string& unblockUserName) override;
  virtual bool WhisperUser(const std::string& whisperUserName, const std::string& message) override;
  virtual bool CreateRaid(const std::string& raidTargetUserName) override;
  virtual bool CancelRaid() override;
  virtual bool GrantVIP(const std::string& vipUserName) override;
  virtual bool RevokeVIP(const std::string& unvipUserName) override;
  virtual bool ListVIPs() override;
};
