/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ichatraidlistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaChatRaidListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaChatRaidListenerProxy : public NativeListenerProxy<chat::IChatRaidListener> {
 public:
  JavaChatRaidListenerProxy();

 public:
  virtual void RaidStarted(const chat::RaidStatus& status) override;
  virtual void RaidUpdated(const chat::RaidStatus& status) override;
  virtual void RaidFired(const chat::RaidStatus& status) override;
  virtual void RaidCancelled(const chat::RaidStatus& status) override;
};
