/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chatroommessagehandler.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

#include <string>

namespace ttv {
namespace binding {
namespace java {
class JavaChatRoomMessageHandlerCallbacksProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaChatRoomMessageHandlerCallbacksProxy
    : public NativeListenerProxy<chat::ChatRoomMessageHandler::ICallbacks> {
 public:
  JavaChatRoomMessageHandlerCallbacksProxy();

 public:
  virtual bool PassThrough(const std::string& message) override;
  virtual bool BanUser(const std::string& userName) override;
  virtual bool TimeoutUser(const std::string& userName, uint32_t duration) override;
  virtual bool SetUserColor(const std::string& color) override;
  virtual bool Help() override;
  virtual bool ListRooms() override;
  virtual bool ModUser(const std::string& userName) override;
  virtual bool ListModerators() override;
  virtual bool SetTopic(const std::string& topic) override;
  virtual bool UnbanUser(const std::string& userName) override;
  virtual bool UnmodUser(const std::string& userName) override;
  virtual bool BlockUser(const std::string& userName) override;
  virtual bool UnblockUser(const std::string& userName) override;
  virtual bool UntimeoutUser(const std::string& userName) override;
  virtual bool SlowMode(bool turnOn, uint32_t durationSeconds) override;
  virtual bool R9kMode(bool turnOn) override;
  virtual bool EmotesOnlyMode(bool turnOn) override;
  virtual bool MalformedCommand(
    chat::ChatRoomMessageHandler::CommandError command, const std::string& commandText) override;
};
