/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chatlistener.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

#include <string>
#include <vector>

namespace ttv {
namespace chat {
class ChatAPI;
}

namespace binding {
namespace java {
class JavaChatUserThreadsListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaChatUserThreadsListenerProxy
    : public NativeListenerProxy<chat::IChatUserThreadsListener> {
 public:
  JavaChatUserThreadsListenerProxy();

 public:
  virtual void ChatThreadRealtimeMessageReceived(
    UserId userId, const std::string& threadId, const chat::WhisperMessage& message) override;
};
