/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chatmessagehandler.h"
#include "twitchsdk/chat/chatroommessagehandler.h"
#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/core/java_utility.h"

namespace ttv {
namespace chat {
class ChatAPI;
class IChatRaid;
class IChatChannel;
class IChannelChatRoomManager;
class IChatRoom;
class IChatRoomNotifications;
class IBitsStatus;
class IFollowersStatus;
class IFollowingStatus;
class ISubscribersStatus;
class IChatChannelProperties;
class IChatCommentManager;
class ISubscriptionsNotifications;
class ISquadNotifications;
class IMultiviewNotifications;
}  // namespace chat

namespace binding {
namespace java {
using namespace ttv::chat;

class JavaChatAPIListenerProxy;
class JavaChatChannelListenerProxy;
class JavaChatUserThreadsListenerProxy;
class JavaChatMessageHandlerCallbacksProxy;
class JavaChatRoomMessageHandlerCallbacksProxy;

struct ChatApiContext {
  std::shared_ptr<ttv::chat::ChatAPI> chatApi;
  std::shared_ptr<JavaChatAPIListenerProxy> nativeListener;
  std::map<ChannelId, std::shared_ptr<JavaChatChannelListenerProxy>> channelListeners;
  std::map<UserId, std::shared_ptr<JavaChatUserThreadsListenerProxy>> userThreadsListeners;
};

extern JavaNativeProxyRegistry<ttv::chat::ChatAPI, ChatApiContext> gChatApiNativeProxyRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IChatRaid, ChatApiContext> gIChatRaidInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IChatChannel, ChatApiContext> gIChatChannelRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IChannelChatRoomManager, ChatApiContext>
  gIChannelChatRoomManagerInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IChatRoom, ChatApiContext> gIChatRoomInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IChatRoomNotifications, ChatApiContext>
  gIChatRoomNotificationsInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IBitsStatus, ChatApiContext> gIBitsStatusInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IFollowersStatus, ChatApiContext> gIFollowersStatusInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IFollowingStatus, ChatApiContext> gIFollowingStatusInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::ISubscribersStatus, ChatApiContext> gISubscribersStatusInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IChatChannelProperties, ChatApiContext>
  gIChatChannelPropertiesInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IChatCommentManager, ChatApiContext> gIChatCommentManagerInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::ISubscriptionsNotifications, ChatApiContext>
  gISubscriptionsNotificationsInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::ISquadNotifications, ChatApiContext> gISquadNotificationsInstanceRegistry;
extern JavaNativeProxyRegistry<ttv::chat::IMultiviewNotifications, ChatApiContext>
  gIMultiviewNotificationsInstanceRegistry;

struct ChatMessageHandlerContext {
  std::shared_ptr<ChatMessageHandler> chatMessageHandler;
  std::shared_ptr<JavaChatMessageHandlerCallbacksProxy> callbacks;
};

struct ChatRoomMessageHandlerContext {
  std::shared_ptr<ChatRoomMessageHandler> chatRoomMessageHandler;
  std::shared_ptr<JavaChatRoomMessageHandlerCallbacksProxy> callbacks;
};

extern JavaNativeProxyRegistry<ChatMessageHandler, ChatMessageHandlerContext> gChatMessageHandlerRegistry;
extern JavaNativeProxyRegistry<ChatRoomMessageHandler, ChatRoomMessageHandlerContext> gChatRoomMessageHandlerRegistry;

/**
 * Loads all Java class information for the chat module.
 */
void LoadAllChatJavaClassInfo(JNIEnv* jEnv);

jobject GetJavaInstance_ChatUserInfo(JNIEnv* jEnv, const ChatUserInfo& user);
jobject GetJavaInstance_ChatUserInfoArray(JNIEnv* jEnv, const std::vector<ChatUserInfo>& list);
jobject GetJavaInstance_ChatChannelInfo(JNIEnv* jEnv, const ChatChannelInfo& channelInfo);
jobject GetJavaInstance_ChatChannelRestrictions(JNIEnv* jEnv, const ChatChannelRestrictions& restrictions);
jobject GetJavaInstance_ChatUserMode(JNIEnv* jEnv, const UserMode& mode);
jobject GetJavaInstance_ChatSubscriptionNotice(JNIEnv* jEnv, const SubscriptionNotice& notice);
jobject GetJavaInstance_ChatSubscriptionNoticeRecipient(JNIEnv* jEnv, const SubscriptionNotice::Recipient& recipient);
jobject GetJavaInstance_ChatFirstTimeChatterNotice(JNIEnv* jEnv, const FirstTimeChatterNotice& notice);
jobject GetJavaInstance_ChatRaidNotice(JNIEnv* jEnv, const RaidNotice& notice);
jobject GetJavaInstance_ChatUnraidNotice(JNIEnv* jEnv, const UnraidNotice& notice);
jobject GetJavaInstance_ChatGenericMessageNotice(JNIEnv* jEnv, const GenericMessageNotice& notice);
jobject GetJavaInstance_ChatRestrictionReason(JNIEnv* jEnv, const RestrictionReason& reason);
jobject GetJavaInstance_ChatTokenizationOptions(JNIEnv* jEnv, const TokenizationOptions& options);
jobject GetJavaInstance_ChatMessageFlags(JNIEnv* jEnv, const MessageInfo::Flags& flags);
jobject GetJavaInstance_ChatMessageToken(JNIEnv* jEnv, const MessageToken& token);
jobject GetJavaInstance_ChatMessageBadge(JNIEnv* jEnv, const MessageBadge& badge);
jobject GetJavaInstance_ChatMessageInfo(JNIEnv* jEnv, const MessageInfo& msg);
jobject GetJavaInstance_ChatLiveMessage(JNIEnv* jEnv, const LiveChatMessage& msg);
jobject GetJavaInstance_ChatLiveMessageArray(JNIEnv* jEnv, const std::vector<LiveChatMessage>& messageList);
jobject GetJavaInstance_ChatColferLiveMessageArray(JNIEnv* jEnv, const std::vector<LiveChatMessage>& messageList);
jobject GetJavaInstance_ChatWhisperMessage(JNIEnv* jEnv, const WhisperMessage& msg);
jobject GetJavaInstance_ChatWhisperMessageArray(JNIEnv* jEnv, const std::vector<WhisperMessage>& messageList);
jobject GetJavaInstance_ChatBadgeImage(JNIEnv* jEnv, const BadgeImage& image);
jobject GetJavaInstance_ChatBadgeVersion(JNIEnv* jEnv, const BadgeVersion& badgeVersion);
jobject GetJavaInstance_ChatBadge(JNIEnv* jEnv, const Badge& badge);
jobject GetJavaInstance_ChatBadgeSet(JNIEnv* jEnv, const BadgeSet& badgeSet);
jobject GetJavaInstance_ChatEmoticon(JNIEnv* jEnv, const Emoticon& emoticon);
jobject GetJavaInstance_ChatEmoticonSet(JNIEnv* jEnv, const EmoticonSet& emoticonSet);
jobject GetJavaInstance_ChatEmoticonSets(JNIEnv* jEnv, const std::vector<EmoticonSet>& emoticonSets);
jobject GetJavaInstance_ChatRaidStatus(JNIEnv* jEnv, const RaidStatus& val);
jobject GetJavaInstance_ChatBadgeEntitlement(JNIEnv* jEnv, const BadgeEntitlement& badgeEntitlement);
jobject GetJavaInstance_ChatBitsReceivedEvent(JNIEnv* jEnv, const BitsReceivedEvent& bitsReceivedEvent);
jobject GetJavaInstance_ChatBitsSentEvent(JNIEnv* jEnv, const BitsSentEvent& bitsSentEvent);
jobject GetJavaInstance_ChatFollowerAddedEvent(JNIEnv* jEnv, const FollowerAddedEvent& followerAddedEvent);
jobject GetJavaInstance_ChatSubscriberAddedEvent(JNIEnv* jEnv, const SubscriberAddedEvent& subscriberAddedEvent);
jobject GetJavaInstance_ChatRoomInfo(JNIEnv* jEnv, const ChatRoomInfo& value);
jobject GetJavaInstance_ChatRoomMessage(JNIEnv* jEnv, const ChatRoomMessage& value);
jobject GetJavaInstance_ChatRoomView(JNIEnv* jEnv, const ChatRoomView& value);
jobject GetJavaInstance_ChatRoomRolePermissions(JNIEnv* jEnv, const RoomRolePermissions& permissions);
jobject GetJavaInstance_ChatRoomPermissions(JNIEnv* jEnv, const ChatRoomPermissions& value);
jobject GetJavaInstance_RoomMentionInfo(JNIEnv* jEnv, const RoomMentionInfo& value);
jobject GetJavaInstance_ChatRoomMessageHandlerCommandError(JNIEnv* jEnv, ChatRoomMessageHandler::CommandError value);
jobject GetJavaInstance_SendRoomMessageError(JNIEnv* jEnv, const SendRoomMessageError& value);
jobject GetJavaInstance_CreateRoomError(JNIEnv* jEnv, const CreateRoomError& value);
jobject GetJavaInstance_UpdateRoomError(JNIEnv* jEnv, const UpdateRoomError& value);
jobject GetJavaInstance_UpdateRoomModesError(JNIEnv* jEnv, const UpdateRoomModesError& value);
jobject GetJavaInstance_BanUserError(JNIEnv* jEnv, const BanUserError& value);
jobject GetJavaInstance_UnbanUserError(JNIEnv* jEnv, const UnbanUserError& value);
jobject GetJavaInstance_ModUserError(JNIEnv* jEnv, const ModUserError& value);
jobject GetJavaInstance_UnmodUserError(JNIEnv* jEnv, const UnmodUserError& value);
jobject GetJavaInstance_ChatComment(JNIEnv* jEnv, const ChatComment& comment);
jobject GetJavaInstance_ChatCommentArray(JNIEnv* jEnv, const std::vector<ChatComment>& comments);
jobject GetJavaInstance_ChannelVodCommentSettings(JNIEnv* jEnv, const ChannelVodCommentSettings& settings);
jobject GetJavaInstance_ModerationActionInfo(JNIEnv* jEnv, const ModerationActionInfo& modActionInfo);
jobject GetJavaInstance_ExtensionMessage(JNIEnv* jEnv, const ExtensionMessage& message);
jobject GetJavaInstance_AutoModFlags(JNIEnv* jEnv, const AutoModFlags& flags);
jobject GetJavaInstance_MultiviewContentAttribute(JNIEnv* jEnv, const MultiviewContentAttribute& attribute);
jobject GetJavaInstance_Chanlet(JNIEnv* jEnv, const Chanlet& chanlet);

void GetNativeInstance_ChatTokenizationOptions(JNIEnv* jEnv, jobject jOptions, TokenizationOptions& options);
void GetNativeInstance_ChatFeatureFlags(JNIEnv* jEnv, jobject jFlags, FeatureFlags& flags);
void GetNativeInstance_RoomRolePermissions(JNIEnv* jEnv, jobject jPermissions, RoomRolePermissions& permissions);
}  // namespace java
}  // namespace binding
}  // namespace ttv
