/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ifollowinglistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaFollowingListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaFollowingListenerProxy : public NativeListenerProxy<chat::IFollowingListener> {
 public:
  JavaFollowingListenerProxy();

 public:
  virtual void FollowedChannel(UserId userId, ChannelId channelId) override;
  virtual void UnfollowedChannel(UserId userId, ChannelId channelId) override;
};
