/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/ichannelchatroommanagerlistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaIChannelChatRoomManagerListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaIChannelChatRoomManagerListenerProxy
    : public NativeListenerProxy<chat::IChannelChatRoomManagerListener> {
 public:
  JavaIChannelChatRoomManagerListenerProxy();

 public:
  virtual void PurgeMessages(UserId userId, ChannelId channelId, Timestamp purgeAfter) override;
  virtual void RoomCreated(ChannelId ownerId, chat::ChatRoomInfo&& roomInfo) override;
  virtual void RoomDeleted(ChannelId ownerId, chat::ChatRoomInfo&& roomInfo) override;
};
