/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ichatchannelpropertylistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaIChatChannelPropertyListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaIChatChannelPropertyListenerProxy
    : public NativeListenerProxy<chat::IChatChannelPropertyListener> {
 public:
  JavaIChatChannelPropertyListenerProxy();

 public:
  virtual void RitualsEnabled(bool ritualsEnabled) override;
  virtual void OutgoingHostChanged(ChannelId channelId, ChannelId previousTarget, ChannelId currentTarget,
    std::string&& currentTargetName, uint32_t numViewers) override;
  virtual void IncomingHostStarted(
    ChannelId channelId, ChannelId hostChannelId, std::string&& hostChannelName, uint32_t numViewers) override;
  virtual void IncomingHostEnded(ChannelId channelId, ChannelId hostChannelId, std::string&& hostChannelName) override;
  virtual void ExtensionMessageReceived(chat::ExtensionMessage&& message) override;
  virtual void ChatChannelRestrictionsReceived(chat::ChatChannelRestrictions&& chatChannelRestrictions) override;
};
