/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chatlistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

#include <vector>

namespace ttv {
namespace binding {
namespace java {
class JavaIChatCommentListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaIChatCommentListenerProxy : public NativeListenerProxy<chat::IChatCommentListener> {
 public:
  JavaIChatCommentListenerProxy();

 public:
  virtual void ChatCommentManagerStateChanged(
    UserId userId, const std::string& vodId, chat::IChatCommentManager::PlayingState state) override;
  virtual void ChatCommentsReceived(
    UserId userId, const std::string& vodId, std::vector<chat::ChatComment>&& messageList) override;
  virtual void ChatCommentsErrorReceived(const std::string& errorMsg, TTV_ErrorCode ec) override;
};
