/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/ichatroomlistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaIChatRoomListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaIChatRoomListenerProxy : public NativeListenerProxy<chat::IChatRoomListener> {
 public:
  JavaIChatRoomListenerProxy();

 public:
  virtual void MessageReceived(const std::string& roomId, chat::ChatRoomMessage&& message) override;
  virtual void MessageEdited(const std::string& roomId, chat::ChatRoomMessage&& message) override;
  virtual void MessageDeleted(const std::string& roomId, chat::ChatRoomMessage&& message) override;
  virtual void RoomUpdated(chat::ChatRoomInfo&& roomInfo) override;
};
