/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/ichatroomnotificationslistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaIChatRoomNotificationsListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaIChatRoomNotificationsListenerProxy
    : public NativeListenerProxy<chat::IChatRoomNotificationsListener> {
 public:
  JavaIChatRoomNotificationsListenerProxy();

 public:
  virtual void UserTimedOut(UserId userId, ChannelId channelId, Timestamp expiresAt) override;
  virtual void UserBanned(UserId userId, ChannelId channelId) override;
  virtual void UserUnbanned(UserId userId, ChannelId channelId) override;
  virtual void RoomViewUpdated(
    UserId userId, ChannelId ownerId, const std::string& roomId, chat::ChatRoomView&& roomViewInfo) override;
  virtual void RoomMentionReceived(UserId userId, chat::RoomMentionInfo&& mentionInfo) override;
};
