/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/isquadnotificationslistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaISquadNotificationsListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaISquadNotificationsListenerProxy
    : public NativeListenerProxy<chat::ISquadNotificationsListener> {
 public:
  JavaISquadNotificationsListenerProxy();

 public:
  virtual void SquadUpdated(SquadInfo&& squad) override;
  virtual void SquadEnded() override;
};
