/****************************************************************************
 * Twitch SDK
 *
 * This software is supplied under the terms of a license agreement with
 * Twitch Interactive, Inc. and may not be copied or used except in accordance
 * with the terms of that agreement
 *
 * Copyright (c) 2012-2016 Twitch Interactive, Inc.
 ***************************************************************************/

#pragma once

#include "twitchsdk/chat/chattypes.h"
#include "twitchsdk/chat/isubscriberslistener.h"
#include "twitchsdk/core/java_coreutil.h"
#include "twitchsdk/core/java_nativelistener.h"

namespace ttv {
namespace binding {
namespace java {
class JavaSubscribersListenerProxy;
}
}  // namespace binding
}  // namespace ttv

class ttv::binding::java::JavaSubscribersListenerProxy : public NativeListenerProxy<chat::ISubscribersListener> {
 public:
  JavaSubscribersListenerProxy();

 public:
  virtual void NewSubscriberAdded(const chat::SubscriberAddedEvent& subscriberAddedEvent) override;
};
