// Code generated by colf(1); DO NOT EDIT.
// The compiler used schema file sdk_colfer.colf for package Colfer.

#include "twitchsdk/chat/generated/colfer_chatmessagearray.h"
#include <errno.h>
#include <stdlib.h>

#if defined(__BYTE_ORDER) && __BYTE_ORDER == __BIG_ENDIAN || \
    defined(__BIG_ENDIAN__) || \
    defined(__ARMEB__) || \
    defined(__AARCH64EB__) || \
    defined(_MIPSEB) || defined(__MIPSEB) || defined(__MIPSEB__) || \
    defined(__SYSC_ZARCH__)
#define COLFER_ENDIAN
#endif


size_t colfer_size_max = 16 * 1024 * 1024;
size_t colfer_list_max = 64 * 1024;



size_t colfer_message_token_marshal_len(const colfer_message_token* o) {
    size_t l = 1;

    if (o->token_type) l += 2;

    {
        size_t n = o->text_field_1.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    {
        size_t n = o->text_field_2.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    {
        uint_fast32_t x = o->num_field;
        if (x) {
            if (x >= (uint_fast32_t) 1 << 21) l += 5;
            else for (l += 2; x > 127; x >>= 7, ++l);
        }
    }

    {
        uint_fast32_t x = o->aggressive_level;
        if (x) {
            if (x >= (uint_fast32_t) 1 << 21) l += 5;
            else for (l += 2; x > 127; x >>= 7, ++l);
        }
    }

    {
        uint_fast32_t x = o->identity_level;
        if (x) {
            if (x >= (uint_fast32_t) 1 << 21) l += 5;
            else for (l += 2; x > 127; x >>= 7, ++l);
        }
    }

    {
        uint_fast32_t x = o->profanity_level;
        if (x) {
            if (x >= (uint_fast32_t) 1 << 21) l += 5;
            else for (l += 2; x > 127; x >>= 7, ++l);
        }
    }

    {
        uint_fast32_t x = o->sexual_level;
        if (x) {
            if (x >= (uint_fast32_t) 1 << 21) l += 5;
            else for (l += 2; x > 127; x >>= 7, ++l);
        }
    }

    if (o->bool_field) l++;

    if (l > colfer_size_max) {
        errno = EFBIG;
        return 0;
    }
    return l;
}

size_t colfer_message_token_marshal(const colfer_message_token* o, uint8_t* buf) {
    // octet pointer navigation
    uint8_t* p = buf;

    if (o->token_type) {
        *p++ = 0;

        *p++ = o->token_type;
    }

    {
        size_t n = o->text_field_1.len;
        if (n) {
            *p++ = 1;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->text_field_1.utf8, n);
            p += n;
        }
    }

    {
        size_t n = o->text_field_2.len;
        if (n) {
            *p++ = 2;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->text_field_2.utf8, n);
            p += n;
        }
    }

    {
        uint_fast32_t x = o->num_field;
        if (x) {
            if (x < (uint_fast32_t) 1 << 21) {
                *p++ = 3;
                for (; x >= 128; x >>= 7) *p++ = x | 128;
                *p++ = x;
            } else {
                *p++ = 3 | 128;
#ifdef COLFER_ENDIAN
                memcpy(p, &o->num_field, 4);
                p += 4;
#else
                *p++ = x >> 24;
                *p++ = x >> 16;
                *p++ = x >> 8;
                *p++ = x;
#endif
            }
        }
    }

    {
        uint_fast32_t x = o->aggressive_level;
        if (x) {
            if (x < (uint_fast32_t) 1 << 21) {
                *p++ = 4;
                for (; x >= 128; x >>= 7) *p++ = x | 128;
                *p++ = x;
            } else {
                *p++ = 4 | 128;
#ifdef COLFER_ENDIAN
                memcpy(p, &o->aggressive_level, 4);
                p += 4;
#else
                *p++ = x >> 24;
                *p++ = x >> 16;
                *p++ = x >> 8;
                *p++ = x;
#endif
            }
        }
    }

    {
        uint_fast32_t x = o->identity_level;
        if (x) {
            if (x < (uint_fast32_t) 1 << 21) {
                *p++ = 5;
                for (; x >= 128; x >>= 7) *p++ = x | 128;
                *p++ = x;
            } else {
                *p++ = 5 | 128;
#ifdef COLFER_ENDIAN
                memcpy(p, &o->identity_level, 4);
                p += 4;
#else
                *p++ = x >> 24;
                *p++ = x >> 16;
                *p++ = x >> 8;
                *p++ = x;
#endif
            }
        }
    }

    {
        uint_fast32_t x = o->profanity_level;
        if (x) {
            if (x < (uint_fast32_t) 1 << 21) {
                *p++ = 6;
                for (; x >= 128; x >>= 7) *p++ = x | 128;
                *p++ = x;
            } else {
                *p++ = 6 | 128;
#ifdef COLFER_ENDIAN
                memcpy(p, &o->profanity_level, 4);
                p += 4;
#else
                *p++ = x >> 24;
                *p++ = x >> 16;
                *p++ = x >> 8;
                *p++ = x;
#endif
            }
        }
    }

    {
        uint_fast32_t x = o->sexual_level;
        if (x) {
            if (x < (uint_fast32_t) 1 << 21) {
                *p++ = 7;
                for (; x >= 128; x >>= 7) *p++ = x | 128;
                *p++ = x;
            } else {
                *p++ = 7 | 128;
#ifdef COLFER_ENDIAN
                memcpy(p, &o->sexual_level, 4);
                p += 4;
#else
                *p++ = x >> 24;
                *p++ = x >> 16;
                *p++ = x >> 8;
                *p++ = x;
#endif
            }
        }
    }

    if (o->bool_field) *p++ = 8;

    *p++ = 127;

    return p - (uint8_t*) buf;
}

size_t colfer_message_token_unmarshal(colfer_message_token* o, const uint8_t* data, size_t datalen) {
    // octet pointer navigation
    const uint8_t* p = data;
    const uint8_t* end;
    int enderr;
    if (datalen < colfer_size_max) {
        end = p + datalen;
        enderr = EWOULDBLOCK;
    } else {
        end = p + colfer_size_max;
        enderr = EFBIG;
    }

    if (p >= end) {
        errno = enderr;
        return 0;
    }
    uint_fast8_t header = *p++;

    if (header == 0) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        o->token_type = *p++;
        header = *p++;
    }

    if (header == 1) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->text_field_1.len = n;

        void* a = malloc(n);
        o->text_field_1.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header == 2) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->text_field_2.len = n;

        void* a = malloc(n);
        o->text_field_2.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header == 3) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        if (x > 127) {
            x &= 127;
            for (int shift = 7; ; shift += 7) {
                uint_fast32_t b = *p++;
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                if (b <= 127) {
                    x |= b << shift;
                    break;
                }
                x |= (b & 127) << shift;
            }
        }
        o->num_field = x;
        header = *p++;
    } else if (header == (3 | 128)) {
        if (p+4 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        x <<= 24;
        x |= (uint_fast32_t) *p++ << 16;
        x |= (uint_fast32_t) *p++ << 8;
        x |= (uint_fast32_t) *p++;
        o->num_field = x;
        header = *p++;
    }

    if (header == 4) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        if (x > 127) {
            x &= 127;
            for (int shift = 7; ; shift += 7) {
                uint_fast32_t b = *p++;
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                if (b <= 127) {
                    x |= b << shift;
                    break;
                }
                x |= (b & 127) << shift;
            }
        }
        o->aggressive_level = x;
        header = *p++;
    } else if (header == (4 | 128)) {
        if (p+4 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        x <<= 24;
        x |= (uint_fast32_t) *p++ << 16;
        x |= (uint_fast32_t) *p++ << 8;
        x |= (uint_fast32_t) *p++;
        o->aggressive_level = x;
        header = *p++;
    }

    if (header == 5) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        if (x > 127) {
            x &= 127;
            for (int shift = 7; ; shift += 7) {
                uint_fast32_t b = *p++;
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                if (b <= 127) {
                    x |= b << shift;
                    break;
                }
                x |= (b & 127) << shift;
            }
        }
        o->identity_level = x;
        header = *p++;
    } else if (header == (5 | 128)) {
        if (p+4 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        x <<= 24;
        x |= (uint_fast32_t) *p++ << 16;
        x |= (uint_fast32_t) *p++ << 8;
        x |= (uint_fast32_t) *p++;
        o->identity_level = x;
        header = *p++;
    }

    if (header == 6) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        if (x > 127) {
            x &= 127;
            for (int shift = 7; ; shift += 7) {
                uint_fast32_t b = *p++;
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                if (b <= 127) {
                    x |= b << shift;
                    break;
                }
                x |= (b & 127) << shift;
            }
        }
        o->profanity_level = x;
        header = *p++;
    } else if (header == (6 | 128)) {
        if (p+4 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        x <<= 24;
        x |= (uint_fast32_t) *p++ << 16;
        x |= (uint_fast32_t) *p++ << 8;
        x |= (uint_fast32_t) *p++;
        o->profanity_level = x;
        header = *p++;
    }

    if (header == 7) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        if (x > 127) {
            x &= 127;
            for (int shift = 7; ; shift += 7) {
                uint_fast32_t b = *p++;
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                if (b <= 127) {
                    x |= b << shift;
                    break;
                }
                x |= (b & 127) << shift;
            }
        }
        o->sexual_level = x;
        header = *p++;
    } else if (header == (7 | 128)) {
        if (p+4 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        x <<= 24;
        x |= (uint_fast32_t) *p++ << 16;
        x |= (uint_fast32_t) *p++ << 8;
        x |= (uint_fast32_t) *p++;
        o->sexual_level = x;
        header = *p++;
    }

    if (header == 8) {
        o->bool_field = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header != 127) {
        errno = EILSEQ;
        return 0;
    }

    return (size_t) (p - (const uint8_t*) data);
}

size_t colfer_message_badge_marshal_len(const colfer_message_badge* o) {
    size_t l = 1;

    {
        size_t n = o->name.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    {
        size_t n = o->version.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    if (l > colfer_size_max) {
        errno = EFBIG;
        return 0;
    }
    return l;
}

size_t colfer_message_badge_marshal(const colfer_message_badge* o, uint8_t* buf) {
    // octet pointer navigation
    uint8_t* p = buf;

    {
        size_t n = o->name.len;
        if (n) {
            *p++ = 0;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->name.utf8, n);
            p += n;
        }
    }

    {
        size_t n = o->version.len;
        if (n) {
            *p++ = 1;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->version.utf8, n);
            p += n;
        }
    }

    *p++ = 127;

    return p - (uint8_t*) buf;
}

size_t colfer_message_badge_unmarshal(colfer_message_badge* o, const uint8_t* data, size_t datalen) {
    // octet pointer navigation
    const uint8_t* p = data;
    const uint8_t* end;
    int enderr;
    if (datalen < colfer_size_max) {
        end = p + datalen;
        enderr = EWOULDBLOCK;
    } else {
        end = p + colfer_size_max;
        enderr = EFBIG;
    }

    if (p >= end) {
        errno = enderr;
        return 0;
    }
    uint_fast8_t header = *p++;

    if (header == 0) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->name.len = n;

        void* a = malloc(n);
        o->name.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header == 1) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->version.len = n;

        void* a = malloc(n);
        o->version.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header != 127) {
        errno = EILSEQ;
        return 0;
    }

    return (size_t) (p - (const uint8_t*) data);
}

size_t colfer_message_tag_marshal_len(const colfer_message_tag* o) {
    size_t l = 1;

    {
        size_t n = o->key.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    {
        size_t n = o->value.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    if (l > colfer_size_max) {
        errno = EFBIG;
        return 0;
    }
    return l;
}

size_t colfer_message_tag_marshal(const colfer_message_tag* o, uint8_t* buf) {
    // octet pointer navigation
    uint8_t* p = buf;

    {
        size_t n = o->key.len;
        if (n) {
            *p++ = 0;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->key.utf8, n);
            p += n;
        }
    }

    {
        size_t n = o->value.len;
        if (n) {
            *p++ = 1;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->value.utf8, n);
            p += n;
        }
    }

    *p++ = 127;

    return p - (uint8_t*) buf;
}

size_t colfer_message_tag_unmarshal(colfer_message_tag* o, const uint8_t* data, size_t datalen) {
    // octet pointer navigation
    const uint8_t* p = data;
    const uint8_t* end;
    int enderr;
    if (datalen < colfer_size_max) {
        end = p + datalen;
        enderr = EWOULDBLOCK;
    } else {
        end = p + colfer_size_max;
        enderr = EFBIG;
    }

    if (p >= end) {
        errno = enderr;
        return 0;
    }
    uint_fast8_t header = *p++;

    if (header == 0) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->key.len = n;

        void* a = malloc(n);
        o->key.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header == 1) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->value.len = n;

        void* a = malloc(n);
        o->value.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header != 127) {
        errno = EILSEQ;
        return 0;
    }

    return (size_t) (p - (const uint8_t*) data);
}

size_t colfer_chat_message_marshal_len(const colfer_chat_message* o) {
    size_t l = 1;

    {
        size_t n = o->message_id.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    {
        size_t n = o->user_name.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    {
        size_t n = o->display_name.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    {
        size_t n = o->message_type.len;
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (n) for (l += 2 + n; n > 127; n >>= 7, ++l);
    }

    {
        uint_fast32_t x = o->user_id;
        if (x) {
            if (x >= (uint_fast32_t) 1 << 21) l += 5;
            else for (l += 2; x > 127; x >>= 7, ++l);
        }
    }

    {
        uint_fast32_t x = o->name_color_argb;
        if (x) {
            if (x >= (uint_fast32_t) 1 << 21) l += 5;
            else for (l += 2; x > 127; x >>= 7, ++l);
        }
    }

    {
        uint_fast32_t x = o->timestamp;
        if (x) {
            if (x >= (uint_fast32_t) 1 << 21) l += 5;
            else for (l += 2; x > 127; x >>= 7, ++l);
        }
    }

    {
        uint_fast32_t x = o->num_bits_sent;
        if (x) {
            if (x >= (uint_fast32_t) 1 << 21) l += 5;
            else for (l += 2; x > 127; x >>= 7, ++l);
        }
    }

    if (o->usermode_moderator) l++;

    if (o->usermode_broadcaster) l++;

    if (o->usermode_administrator) l++;

    if (o->usermode_staff) l++;

    if (o->usermode_system) l++;

    if (o->usermode_global_moderator) l++;

    if (o->usermode_banned) l++;

    if (o->usermode_subscriber) l++;

    if (o->usermode_vip) l++;

    if (o->messageflags_action) l++;

    if (o->messageflags_notice) l++;

    if (o->messageflags_ignored) l++;

    if (o->messageflags_deleted) l++;

    if (o->messageflags_contains_bits) l++;

    {
        size_t n = o->tokens.len;
        if (n) {
            if (n > colfer_list_max) {
                errno = EFBIG;
                return 0;
            }
            colfer_message_token* a = o->tokens.list;
            for (size_t i = 0; i < n; ++i) l += colfer_message_token_marshal_len(&a[i]);
            for (l += 2; n > 127; n >>= 7, ++l);
            if (l > colfer_size_max) {
                errno = EFBIG;
                return 0;
            }
        }
    }

    {
        size_t n = o->badges.len;
        if (n) {
            if (n > colfer_list_max) {
                errno = EFBIG;
                return 0;
            }
            colfer_message_badge* a = o->badges.list;
            for (size_t i = 0; i < n; ++i) l += colfer_message_badge_marshal_len(&a[i]);
            for (l += 2; n > 127; n >>= 7, ++l);
            if (l > colfer_size_max) {
                errno = EFBIG;
                return 0;
            }
        }
    }

    {
        size_t n = o->message_tags.len;
        if (n) {
            if (n > colfer_list_max) {
                errno = EFBIG;
                return 0;
            }
            colfer_message_tag* a = o->message_tags.list;
            for (size_t i = 0; i < n; ++i) l += colfer_message_tag_marshal_len(&a[i]);
            for (l += 2; n > 127; n >>= 7, ++l);
            if (l > colfer_size_max) {
                errno = EFBIG;
                return 0;
            }
        }
    }

    if (l > colfer_size_max) {
        errno = EFBIG;
        return 0;
    }
    return l;
}

size_t colfer_chat_message_marshal(const colfer_chat_message* o, uint8_t* buf) {
    // octet pointer navigation
    uint8_t* p = buf;

    {
        size_t n = o->message_id.len;
        if (n) {
            *p++ = 0;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->message_id.utf8, n);
            p += n;
        }
    }

    {
        size_t n = o->user_name.len;
        if (n) {
            *p++ = 1;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->user_name.utf8, n);
            p += n;
        }
    }

    {
        size_t n = o->display_name.len;
        if (n) {
            *p++ = 2;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->display_name.utf8, n);
            p += n;
        }
    }

    {
        size_t n = o->message_type.len;
        if (n) {
            *p++ = 3;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            memcpy(p, o->message_type.utf8, n);
            p += n;
        }
    }

    {
        uint_fast32_t x = o->user_id;
        if (x) {
            if (x < (uint_fast32_t) 1 << 21) {
                *p++ = 4;
                for (; x >= 128; x >>= 7) *p++ = x | 128;
                *p++ = x;
            } else {
                *p++ = 4 | 128;
#ifdef COLFER_ENDIAN
                memcpy(p, &o->user_id, 4);
                p += 4;
#else
                *p++ = x >> 24;
                *p++ = x >> 16;
                *p++ = x >> 8;
                *p++ = x;
#endif
            }
        }
    }

    {
        uint_fast32_t x = o->name_color_argb;
        if (x) {
            if (x < (uint_fast32_t) 1 << 21) {
                *p++ = 5;
                for (; x >= 128; x >>= 7) *p++ = x | 128;
                *p++ = x;
            } else {
                *p++ = 5 | 128;
#ifdef COLFER_ENDIAN
                memcpy(p, &o->name_color_argb, 4);
                p += 4;
#else
                *p++ = x >> 24;
                *p++ = x >> 16;
                *p++ = x >> 8;
                *p++ = x;
#endif
            }
        }
    }

    {
        uint_fast32_t x = o->timestamp;
        if (x) {
            if (x < (uint_fast32_t) 1 << 21) {
                *p++ = 6;
                for (; x >= 128; x >>= 7) *p++ = x | 128;
                *p++ = x;
            } else {
                *p++ = 6 | 128;
#ifdef COLFER_ENDIAN
                memcpy(p, &o->timestamp, 4);
                p += 4;
#else
                *p++ = x >> 24;
                *p++ = x >> 16;
                *p++ = x >> 8;
                *p++ = x;
#endif
            }
        }
    }

    {
        uint_fast32_t x = o->num_bits_sent;
        if (x) {
            if (x < (uint_fast32_t) 1 << 21) {
                *p++ = 7;
                for (; x >= 128; x >>= 7) *p++ = x | 128;
                *p++ = x;
            } else {
                *p++ = 7 | 128;
#ifdef COLFER_ENDIAN
                memcpy(p, &o->num_bits_sent, 4);
                p += 4;
#else
                *p++ = x >> 24;
                *p++ = x >> 16;
                *p++ = x >> 8;
                *p++ = x;
#endif
            }
        }
    }

    if (o->usermode_moderator) *p++ = 8;

    if (o->usermode_broadcaster) *p++ = 9;

    if (o->usermode_administrator) *p++ = 10;

    if (o->usermode_staff) *p++ = 11;

    if (o->usermode_system) *p++ = 12;

    if (o->usermode_global_moderator) *p++ = 13;

    if (o->usermode_banned) *p++ = 14;

    if (o->usermode_subscriber) *p++ = 15;

    if (o->usermode_vip) *p++ = 16;

    if (o->messageflags_action) *p++ = 17;

    if (o->messageflags_notice) *p++ = 18;

    if (o->messageflags_ignored) *p++ = 19;

    if (o->messageflags_deleted) *p++ = 20;

    if (o->messageflags_contains_bits) *p++ = 21;

    {
        size_t n = o->tokens.len;
        if (n) {
            *p++ = 22;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            colfer_message_token* a = o->tokens.list;
            for (size_t i = 0; i < n; ++i) p += colfer_message_token_marshal(&a[i], p);
        }
    }

    {
        size_t n = o->badges.len;
        if (n) {
            *p++ = 23;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            colfer_message_badge* a = o->badges.list;
            for (size_t i = 0; i < n; ++i) p += colfer_message_badge_marshal(&a[i], p);
        }
    }

    {
        size_t n = o->message_tags.len;
        if (n) {
            *p++ = 24;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            colfer_message_tag* a = o->message_tags.list;
            for (size_t i = 0; i < n; ++i) p += colfer_message_tag_marshal(&a[i], p);
        }
    }

    *p++ = 127;

    return p - (uint8_t*) buf;
}

size_t colfer_chat_message_unmarshal(colfer_chat_message* o, const uint8_t* data, size_t datalen) {
    // octet pointer navigation
    const uint8_t* p = data;
    const uint8_t* end;
    int enderr;
    if (datalen < colfer_size_max) {
        end = p + datalen;
        enderr = EWOULDBLOCK;
    } else {
        end = p + colfer_size_max;
        enderr = EFBIG;
    }

    if (p >= end) {
        errno = enderr;
        return 0;
    }
    uint_fast8_t header = *p++;

    if (header == 0) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->message_id.len = n;

        void* a = malloc(n);
        o->message_id.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header == 1) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->user_name.len = n;

        void* a = malloc(n);
        o->user_name.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header == 2) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->display_name.len = n;

        void* a = malloc(n);
        o->display_name.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header == 3) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; shift < sizeof(size_t) * CHAR_BIT; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_size_max) {
            errno = EFBIG;
            return 0;
        }
        if (p+n >= end) {
            errno = enderr;
            return 0;
        }
        o->message_type.len = n;

        void* a = malloc(n);
        o->message_type.utf8 = (char*) a;
        if (n) {
            memcpy(a, p, n);
            p += n;
        }
        header = *p++;
    }

    if (header == 4) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        if (x > 127) {
            x &= 127;
            for (int shift = 7; ; shift += 7) {
                uint_fast32_t b = *p++;
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                if (b <= 127) {
                    x |= b << shift;
                    break;
                }
                x |= (b & 127) << shift;
            }
        }
        o->user_id = x;
        header = *p++;
    } else if (header == (4 | 128)) {
        if (p+4 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        x <<= 24;
        x |= (uint_fast32_t) *p++ << 16;
        x |= (uint_fast32_t) *p++ << 8;
        x |= (uint_fast32_t) *p++;
        o->user_id = x;
        header = *p++;
    }

    if (header == 5) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        if (x > 127) {
            x &= 127;
            for (int shift = 7; ; shift += 7) {
                uint_fast32_t b = *p++;
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                if (b <= 127) {
                    x |= b << shift;
                    break;
                }
                x |= (b & 127) << shift;
            }
        }
        o->name_color_argb = x;
        header = *p++;
    } else if (header == (5 | 128)) {
        if (p+4 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        x <<= 24;
        x |= (uint_fast32_t) *p++ << 16;
        x |= (uint_fast32_t) *p++ << 8;
        x |= (uint_fast32_t) *p++;
        o->name_color_argb = x;
        header = *p++;
    }

    if (header == 6) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        if (x > 127) {
            x &= 127;
            for (int shift = 7; ; shift += 7) {
                uint_fast32_t b = *p++;
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                if (b <= 127) {
                    x |= b << shift;
                    break;
                }
                x |= (b & 127) << shift;
            }
        }
        o->timestamp = x;
        header = *p++;
    } else if (header == (6 | 128)) {
        if (p+4 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        x <<= 24;
        x |= (uint_fast32_t) *p++ << 16;
        x |= (uint_fast32_t) *p++ << 8;
        x |= (uint_fast32_t) *p++;
        o->timestamp = x;
        header = *p++;
    }

    if (header == 7) {
        if (p+1 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        if (x > 127) {
            x &= 127;
            for (int shift = 7; ; shift += 7) {
                uint_fast32_t b = *p++;
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                if (b <= 127) {
                    x |= b << shift;
                    break;
                }
                x |= (b & 127) << shift;
            }
        }
        o->num_bits_sent = x;
        header = *p++;
    } else if (header == (7 | 128)) {
        if (p+4 >= end) {
            errno = enderr;
            return 0;
        }
        uint_fast32_t x = *p++;
        x <<= 24;
        x |= (uint_fast32_t) *p++ << 16;
        x |= (uint_fast32_t) *p++ << 8;
        x |= (uint_fast32_t) *p++;
        o->num_bits_sent = x;
        header = *p++;
    }

    if (header == 8) {
        o->usermode_moderator = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 9) {
        o->usermode_broadcaster = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 10) {
        o->usermode_administrator = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 11) {
        o->usermode_staff = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 12) {
        o->usermode_system = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 13) {
        o->usermode_global_moderator = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 14) {
        o->usermode_banned = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 15) {
        o->usermode_subscriber = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 16) {
        o->usermode_vip = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 17) {
        o->messageflags_action = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 18) {
        o->messageflags_notice = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 19) {
        o->messageflags_ignored = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 20) {
        o->messageflags_deleted = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 21) {
        o->messageflags_contains_bits = 1;
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 22) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; ; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_list_max) {
            errno = EFBIG;
            return 0;
        }

        colfer_message_token* a = (colfer_message_token*) calloc(n, sizeof(colfer_message_token));
        for (size_t i = 0; i < n; ++i) {
            size_t read = colfer_message_token_unmarshal(&a[i], p, (size_t) (end - p));
            if (!read) {
                if (errno == EWOULDBLOCK) errno = enderr;
                return read;
            }
            p += read;
        }
        o->tokens.len = n;
        o->tokens.list = a;

        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 23) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; ; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_list_max) {
            errno = EFBIG;
            return 0;
        }

        colfer_message_badge* a = (colfer_message_badge*) calloc(n, sizeof(colfer_message_badge));
        for (size_t i = 0; i < n; ++i) {
            size_t read = colfer_message_badge_unmarshal(&a[i], p, (size_t) (end - p));
            if (!read) {
                if (errno == EWOULDBLOCK) errno = enderr;
                return read;
            }
            p += read;
        }
        o->badges.len = n;
        o->badges.list = a;

        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header == 24) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; ; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_list_max) {
            errno = EFBIG;
            return 0;
        }

        colfer_message_tag* a = (colfer_message_tag*) calloc(n, sizeof(colfer_message_tag));
        for (size_t i = 0; i < n; ++i) {
            size_t read = colfer_message_tag_unmarshal(&a[i], p, (size_t) (end - p));
            if (!read) {
                if (errno == EWOULDBLOCK) errno = enderr;
                return read;
            }
            p += read;
        }
        o->message_tags.len = n;
        o->message_tags.list = a;

        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header != 127) {
        errno = EILSEQ;
        return 0;
    }

    return (size_t) (p - (const uint8_t*) data);
}

size_t colfer_chat_message_array_marshal_len(const colfer_chat_message_array* o) {
    size_t l = 1;

    {
        size_t n = o->messages.len;
        if (n) {
            if (n > colfer_list_max) {
                errno = EFBIG;
                return 0;
            }
            colfer_chat_message* a = o->messages.list;
            for (size_t i = 0; i < n; ++i) l += colfer_chat_message_marshal_len(&a[i]);
            for (l += 2; n > 127; n >>= 7, ++l);
            if (l > colfer_size_max) {
                errno = EFBIG;
                return 0;
            }
        }
    }

    if (l > colfer_size_max) {
        errno = EFBIG;
        return 0;
    }
    return l;
}

size_t colfer_chat_message_array_marshal(const colfer_chat_message_array* o, uint8_t* buf) {
    // octet pointer navigation
    uint8_t* p = buf;

    {
        size_t n = o->messages.len;
        if (n) {
            *p++ = 0;

            uint_fast32_t x = n;
            for (; x >= 128; x >>= 7) *p++ = x | 128;
            *p++ = x;

            colfer_chat_message* a = o->messages.list;
            for (size_t i = 0; i < n; ++i) p += colfer_chat_message_marshal(&a[i], p);
        }
    }

    *p++ = 127;

    return p - (uint8_t*) buf;
}

size_t colfer_chat_message_array_unmarshal(colfer_chat_message_array* o, const uint8_t* data, size_t datalen) {
    // octet pointer navigation
    const uint8_t* p = data;
    const uint8_t* end;
    int enderr;
    if (datalen < colfer_size_max) {
        end = p + datalen;
        enderr = EWOULDBLOCK;
    } else {
        end = p + colfer_size_max;
        enderr = EFBIG;
    }

    if (p >= end) {
        errno = enderr;
        return 0;
    }
    uint_fast8_t header = *p++;

    if (header == 0) {
        if (p >= end) {
            errno = enderr;
            return 0;
        }
        size_t n = *p++;
        if (n > 127) {
            n &= 127;
            for (int shift = 7; ; shift += 7) {
                if (p >= end) {
                    errno = enderr;
                    return 0;
                }
                size_t c = *p++;
                if (c <= 127) {
                    n |= c << shift;
                    break;
                }
                n |= (c & 127) << shift;
            }
        }
        if (n > colfer_list_max) {
            errno = EFBIG;
            return 0;
        }

        colfer_chat_message* a = (colfer_chat_message*) calloc(n, sizeof(colfer_chat_message));
        for (size_t i = 0; i < n; ++i) {
            size_t read = colfer_chat_message_unmarshal(&a[i], p, (size_t) (end - p));
            if (!read) {
                if (errno == EWOULDBLOCK) errno = enderr;
                return read;
            }
            p += read;
        }
        o->messages.len = n;
        o->messages.list = a;

        if (p >= end) {
            errno = enderr;
            return 0;
        }
        header = *p++;
    }

    if (header != 127) {
        errno = EILSEQ;
        return 0;
    }

    return (size_t) (p - (const uint8_t*) data);
}
