/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_automodflags.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_AutoModFlags(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/AutoModFlags");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.AutoModFlags();

        LookupJavaField(jEnv, info, "identityLevel", "I"); // public int identityLevel;
        LookupJavaField(jEnv, info, "sexualLevel", "I"); // public int sexualLevel;
        LookupJavaField(jEnv, info, "aggressiveLevel", "I"); // public int aggressiveLevel;
        LookupJavaField(jEnv, info, "profanityLevel", "I"); // public int profanityLevel;
    }

    return info;
}
