/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatbadgeentitlement.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatBadgeEntitlement(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatBadgeEntitlement");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatBadgeEntitlement();

        LookupJavaField(jEnv, info, "newLevel", "I"); // public int newLevel;
        LookupJavaField(jEnv, info, "previousLevel", "I"); // public int previousLevel;
        LookupJavaField(jEnv, info, "isNewBadgeLevel", "Z"); // public boolean isNewBadgeLevel;
    }

    return info;
}
