/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatbadgeversion.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatBadgeVersion(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatBadgeVersion");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatBadgeVersion();

        LookupJavaField(jEnv, info, "name", "Ljava/lang/String;"); // public java.lang.String name;
        LookupJavaField(jEnv, info, "title", "Ljava/lang/String;"); // public java.lang.String title;
        LookupJavaField(jEnv, info, "description", "Ljava/lang/String;"); // public java.lang.String description;
        LookupJavaField(jEnv, info, "clickAction", "Ltv/twitch/chat/ChatBadgeAction;"); // public tv.twitch.chat.ChatBadgeAction clickAction;
        LookupJavaField(jEnv, info, "clickUrl", "Ljava/lang/String;"); // public java.lang.String clickUrl;
        LookupJavaField(jEnv, info, "images", "[Ltv/twitch/chat/ChatBadgeImage;"); // public tv.twitch.chat.ChatBadgeImage[] images;
    }

    return info;
}
