/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatbitsreceivedevent.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatBitsReceivedEvent(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatBitsReceivedEvent");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatBitsReceivedEvent();

        LookupJavaField(jEnv, info, "message", "Ltv/twitch/chat/ChatMessageInfo;"); // public tv.twitch.chat.ChatMessageInfo message;
        LookupJavaField(jEnv, info, "channelName", "Ljava/lang/String;"); // public java.lang.String channelName;
        LookupJavaField(jEnv, info, "context", "Ljava/lang/String;"); // public java.lang.String context;
        LookupJavaField(jEnv, info, "channelId", "I"); // public int channelId;
        LookupJavaField(jEnv, info, "bitsUsed", "I"); // public int bitsUsed;
        LookupJavaField(jEnv, info, "totalBitsUsed", "I"); // public int totalBitsUsed;
        LookupJavaField(jEnv, info, "badge", "Ltv/twitch/chat/ChatBadgeEntitlement;"); // public tv.twitch.chat.ChatBadgeEntitlement badge;
    }

    return info;
}
