/********************************************************************************************
* Twitch Broadcasting SDK
*
* This software is supplied under the terms of a license agreement with Twitch Interactive, Inc. and
* may not be copied or used except in accordance with the terms of that agreement
* Copyright (c) 2012-2017 Twitch Interactive, Inc.
*********************************************************************************************/

#include "twitchsdk/chat/internal/pch.h"
#include "twitchsdk/chat/generated/java_chatbitssentevent.h"

::ttv::binding::java::JavaClassInfo& ttv::binding::java::GetJavaClassInfo_ChatBitsSentEvent(JNIEnv* jEnv)
{
    static ::ttv::binding::java::JavaClassInfo info;
    static bool initialized = false;

    if (!initialized)
    {
        initialized = true;

        LookupJavaClass(jEnv, info, "tv/twitch/chat/ChatBitsSentEvent");

        LookupJavaMethod(jEnv, info, "<init>", "()V"); // public tv.twitch.chat.ChatBitsSentEvent();

        LookupJavaField(jEnv, info, "channelId", "I"); // public int channelId;
        LookupJavaField(jEnv, info, "userBitsBalance", "I"); // public int userBitsBalance;
        LookupJavaField(jEnv, info, "channelBitsTotal", "I"); // public int channelBitsTotal;
    }

    return info;
}
